; Copyright {{year}} Thorben Stangenberg
;
; Licensed under the Apache License, Version 2.0 (the "License");
; You may not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns docs.documentation
  (:use midje.sweet
        clojure.test)
  (:require [robert.hooke :as rh]
            [convana.core :as convana]
            ))

[[:chapter {:tag "hello" :title "Hello Midje Doc"}]]

"This is an introduction to writing with midje-doc."

[[:section {:title "Defining a function"}]]

"We define function `add-5`"

[[{:numbered false}]]
(defn add-5 [x]
  (+ x 5))

[[:section {:title "Testing a function"}]]

"`add-5` outputs the following results seen in
[e.{{add-5-1}}](#add-5-1) and [e.{{add-5-10}}](#add-5-10):"

(fact
  [[{:tag "add-5-1" :title "1 add 5 = 6"}]]
  (add-5 2) => 7

  [[{:tag "add-5-10" :title "10 add 5 = 15"}]]
  (add-5 10) => 15)