/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.text.StringCharacterIterator;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.commoncrawl.util.shared.BinaryComparableWithOffset;
import org.commoncrawl.util.shared.FlexBuffer;

public final class TextBytes
extends BinaryComparableWithOffset
implements WritableComparable<BinaryComparable>,
Cloneable {
    private static final Log LOG = LogFactory.getLog(TextBytes.class);
    private static ThreadLocal<CharsetEncoder> ENCODER_FACTORY = new ThreadLocal<CharsetEncoder>(){

        @Override
        protected CharsetEncoder initialValue() {
            return Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    };
    private static ThreadLocal<CharsetDecoder> DECODER_FACTORY = new ThreadLocal<CharsetDecoder>(){

        @Override
        protected CharsetDecoder initialValue() {
            return Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    };
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String EMPTY_STRING = new String("");
    private FlexBuffer bytes = new FlexBuffer();
    private String cachedUTF8 = null;
    private static final int LEAD_BYTE = 0;
    private static final int TRAIL_BYTE_1 = 1;
    private static final int TRAIL_BYTE = 2;
    static final int[] bytesFromUTF8;
    static final int[] offsetsFromUTF8;

    public TextBytes() {
    }

    public TextBytes(String string) {
        this.set(string);
    }

    public TextBytes(TextBytes utf8, boolean shared) {
        this.bytes = new FlexBuffer(utf8.bytes, shared);
        this.cachedUTF8 = utf8.cachedUTF8;
    }

    public TextBytes(FlexBuffer utf8Data, boolean shared) {
        this.bytes = shared ? utf8Data : new FlexBuffer(utf8Data, false);
        this.cachedUTF8 = null;
    }

    public TextBytes(Text utf8, boolean shared) {
        this.set(utf8, shared);
    }

    public TextBytes(byte[] utf8, boolean shared) {
        this.set(utf8, shared);
    }

    public TextBytes(byte[] utf8, int offset, int len, boolean shared) {
        this.set(utf8, offset, len, shared);
    }

    public FlexBuffer getBuffer() {
        return this.bytes;
    }

    public byte[] getBytes() {
        return this.bytes.get();
    }

    public int getLength() {
        return this.bytes.getCount();
    }

    @Override
    public int getOffset() {
        return this.bytes.getOffset();
    }

    public void setLength(int newLength) {
        if (newLength > this.getCapacity()) {
            this.setCapacity(newLength, true);
        }
        this.bytes.setCount(newLength);
        this.cachedUTF8 = null;
    }

    public int charAt(int position) {
        if (position > this.bytes.getCount()) {
            return -1;
        }
        if (position < 0) {
            return -1;
        }
        ByteBuffer bb = (ByteBuffer)ByteBuffer.wrap(this.bytes.get(), this.bytes.getOffset(), this.bytes.getCount()).position(position);
        return TextBytes.bytesToCodePoint(bb.slice());
    }

    public int find(String what) {
        return this.find(what, 0);
    }

    public int find(String what, int start) {
        try {
            ByteBuffer src = ByteBuffer.wrap(this.bytes.get(), this.bytes.getOffset(), this.bytes.getCount());
            ByteBuffer tgt = TextBytes.encode(what);
            byte b = tgt.get();
            src.position(start);
            while (src.hasRemaining()) {
                if (b != src.get()) continue;
                src.mark();
                tgt.mark();
                boolean found = true;
                int pos = src.position() - 1;
                while (tgt.hasRemaining()) {
                    if (!src.hasRemaining()) {
                        tgt.reset();
                        src.reset();
                        found = false;
                        break;
                    }
                    if (tgt.get() == src.get()) continue;
                    tgt.reset();
                    src.reset();
                    found = false;
                    break;
                }
                if (!found) continue;
                return pos;
            }
            return -1;
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void set(String string) {
        try {
            ByteBuffer bb = TextBytes.encode(string, true);
            this.set(bb.array(), 0, bb.limit(), false);
            this.cachedUTF8 = string;
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException("Should not have happened " + e.toString());
        }
    }

    public void set(byte[] utf8, boolean shared) {
        this.set(utf8, 0, utf8.length, shared);
    }

    public void set(Text other, boolean shared) {
        this.set(other.getBytes(), 0, other.getLength(), shared);
    }

    public void set(TextBytes other, boolean shared) {
        this.set(other.getBytes(), other.getOffset(), other.getLength(), shared);
    }

    public void set(byte[] utf8, int start, int len, boolean shared) {
        this.bytes.set(utf8, start, len, shared);
        this.cachedUTF8 = null;
    }

    public void append(byte[] utf8, int start, int len) {
        this.setCapacity(this.bytes.getCount() + len, true);
        if (this.bytes.isShared()) {
            this.bytes.copyOnWrite();
        }
        System.arraycopy(utf8, start, this.bytes.get(), this.bytes.getCount(), len);
        this.bytes.setCount(this.bytes.getCount() + len);
        this.cachedUTF8 = null;
    }

    public void clear() {
        this.bytes.setCount(0);
        this.cachedUTF8 = null;
    }

    private void setCapacity(int len, boolean keepData) {
        if (!keepData) {
            boolean oldSharedValue = this.bytes._isShared;
            this.bytes._isShared = false;
            this.bytes.setCount(0);
            this.bytes._isShared = oldSharedValue;
        }
        this.bytes.setCapacity(len);
        this.cachedUTF8 = null;
    }

    private int getCapacity() {
        return this.bytes.getCapacity();
    }

    public String toString() {
        if (this.cachedUTF8 == null) {
            if (this.bytes.getCount() == 0) {
                this.cachedUTF8 = EMPTY_STRING;
            } else {
                try {
                    this.cachedUTF8 = TextBytes.decode(this.bytes.get(), this.bytes.getOffset(), this.bytes.getCount());
                    return this.cachedUTF8;
                }
                catch (CharacterCodingException e) {
                    throw new RuntimeException("Should not have happened " + e.toString());
                }
            }
        }
        return this.cachedUTF8;
    }

    public void readFields(DataInput in) throws IOException {
        int newLength = WritableUtils.readVInt((DataInput)in);
        this.setCapacity(newLength, false);
        this.bytes.copyOnWrite();
        in.readFully(this.bytes.get(), this.bytes.getOffset(), newLength);
        this.bytes.setCount(newLength);
        this.cachedUTF8 = null;
    }

    public static void skip(DataInput in) throws IOException {
        int length = WritableUtils.readVInt((DataInput)in);
        WritableUtils.skipFully((DataInput)in, (int)length);
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.bytes.getCount());
        if (this.bytes.getCount() != 0) {
            out.write(this.bytes.get(), this.bytes.getOffset(), this.bytes.getCount());
        }
    }

    public boolean equals(Object o) {
        if (o instanceof TextBytes) {
            return super.equals(o);
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        int offset = this.getOffset();
        int length = this.getLength();
        byte[] bytesArray = this.bytes.get();
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytesArray[i];
        }
        return hash;
    }

    public static String decode(byte[] utf8) throws CharacterCodingException {
        return TextBytes.decode(ByteBuffer.wrap(utf8), true);
    }

    public static String decode(byte[] utf8, int start, int length) throws CharacterCodingException {
        return TextBytes.decode(ByteBuffer.wrap(utf8, start, length), true);
    }

    public static String decode(byte[] utf8, int start, int length, boolean replace) throws CharacterCodingException {
        return TextBytes.decode(ByteBuffer.wrap(utf8, start, length), replace);
    }

    private static String decode(ByteBuffer utf8, boolean replace) throws CharacterCodingException {
        CharsetDecoder decoder = DECODER_FACTORY.get();
        if (replace) {
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        String str = decoder.decode(utf8).toString();
        if (replace) {
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return str;
    }

    public static ByteBuffer encode(String string) throws CharacterCodingException {
        return TextBytes.encode(string, true);
    }

    public static ByteBuffer encode(String string, boolean replace) throws CharacterCodingException {
        CharsetEncoder encoder = ENCODER_FACTORY.get();
        if (replace) {
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        ByteBuffer bytes = encoder.encode(CharBuffer.wrap(string.toCharArray()));
        if (replace) {
            encoder.onMalformedInput(CodingErrorAction.REPORT);
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        return bytes;
    }

    public static String readString(DataInput in) throws IOException {
        int length = WritableUtils.readVInt((DataInput)in);
        byte[] bytes = new byte[length];
        in.readFully(bytes, 0, length);
        return TextBytes.decode(bytes);
    }

    public static int writeString(DataOutput out, String s) throws IOException {
        ByteBuffer bytes = TextBytes.encode(s);
        int length = bytes.limit();
        WritableUtils.writeVInt((DataOutput)out, (int)length);
        out.write(bytes.array(), 0, length);
        return length;
    }

    public static void validateUTF8(byte[] utf8) throws MalformedInputException {
        TextBytes.validateUTF8(utf8, 0, utf8.length);
    }

    public static void validateUTF8(byte[] utf8, int start, int len) throws MalformedInputException {
        int leadByte = 0;
        int length = 0;
        int state = 0;
        block11: for (int count = start; count < start + len; ++count) {
            int aByte = utf8[count] & 0xFF;
            switch (state) {
                case 0: {
                    leadByte = aByte;
                    length = bytesFromUTF8[aByte];
                    switch (length) {
                        case 0: {
                            if (leadByte <= 127) continue block11;
                            throw new MalformedInputException(count);
                        }
                        case 1: {
                            if (leadByte < 194 || leadByte > 223) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                        case 2: {
                            if (leadByte < 224 || leadByte > 239) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                        case 3: {
                            if (leadByte < 240 || leadByte > 244) {
                                throw new MalformedInputException(count);
                            }
                            state = 1;
                            continue block11;
                        }
                    }
                    throw new MalformedInputException(count);
                }
                case 1: {
                    if (leadByte == 240 && aByte < 144) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 244 && aByte > 143) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 224 && aByte < 160) {
                        throw new MalformedInputException(count);
                    }
                    if (leadByte == 237 && aByte > 159) {
                        throw new MalformedInputException(count);
                    }
                }
                case 2: {
                    if (aByte < 128 || aByte > 191) {
                        throw new MalformedInputException(count);
                    }
                    state = --length == 0 ? 0 : 2;
                }
            }
        }
    }

    public static int bytesToCodePoint(ByteBuffer bytes) {
        bytes.mark();
        byte b = bytes.get();
        bytes.reset();
        int extraBytesToRead = bytesFromUTF8[b & 0xFF];
        if (extraBytesToRead < 0) {
            return -1;
        }
        int ch = 0;
        switch (extraBytesToRead) {
            case 5: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 4: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 3: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 2: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 1: {
                ch += bytes.get() & 0xFF;
                ch <<= 6;
            }
            case 0: {
                ch += bytes.get() & 0xFF;
            }
        }
        return ch -= offsetsFromUTF8[extraBytesToRead];
    }

    public static int utf8Length(String string) {
        StringCharacterIterator iter = new StringCharacterIterator(string);
        char ch = iter.first();
        int size = 0;
        while (ch != '\uffff') {
            if (ch >= '\ud800' && ch < '\udc00') {
                char trail = iter.next();
                if (trail > '\udbff' && trail < '\ue000') {
                    size += 4;
                } else {
                    size += 3;
                    iter.previous();
                }
            } else {
                size = ch < '\u0080' ? ++size : (ch < '\u0800' ? (size += 2) : (size += 3));
            }
            ch = iter.next();
        }
        return size;
    }

    public static void main(String[] args) {
        String aTestString = new String("A Test Strnig");
        byte[] bytes = aTestString.getBytes();
        byte[] overAllocated = new byte[bytes.length * 2];
        System.arraycopy(bytes, 0, overAllocated, bytes.length, bytes.length);
        TextBytes textBytes = new TextBytes();
        textBytes.set(overAllocated, bytes.length, bytes.length, false);
        String toString = textBytes.toString();
        Assert.assertTrue((boolean)aTestString.equals(toString));
        DataOutputBuffer outputBuffer = new DataOutputBuffer();
        try {
            textBytes.write((DataOutput)outputBuffer);
            DataInputBuffer inputBuffer = new DataInputBuffer();
            inputBuffer.reset(outputBuffer.getData(), 0, outputBuffer.size());
            int encodedLength = WritableUtils.readVInt((DataInput)inputBuffer);
            Assert.assertTrue((encodedLength == bytes.length ? 1 : 0) != 0);
            Assert.assertEquals((int)WritableComparator.compareBytes((byte[])bytes, (int)0, (int)bytes.length, (byte[])outputBuffer.getData(), (int)inputBuffer.getPosition(), (int)(outputBuffer.getLength() - inputBuffer.getPosition())), (int)0);
            inputBuffer.reset(outputBuffer.getData(), 0, outputBuffer.size());
            textBytes.readFields((DataInput)inputBuffer);
            Assert.assertTrue((textBytes.getBytes() != overAllocated ? 1 : 0) != 0);
            Assert.assertEquals((int)WritableComparator.compareBytes((byte[])bytes, (int)0, (int)bytes.length, (byte[])textBytes.getBytes(), (int)textBytes.getOffset(), (int)textBytes.getLength()), (int)0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        TextBytes result = new TextBytes();
        result.bytes.copy(this.bytes.get(), this.bytes.getOffset(), this.bytes.getCount());
        result.cachedUTF8 = this.cachedUTF8;
        return result;
    }

    static {
        WritableComparator.define(Text.class, (WritableComparator)new Comparator());
        bytesFromUTF8 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5};
        offsetsFromUTF8 = new int[]{0, 12416, 925824, 63447168, -100130688, -2113396608};
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(Text.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int n1 = WritableUtils.decodeVIntSize((byte)b1[s1]);
            int n2 = WritableUtils.decodeVIntSize((byte)b2[s2]);
            return Comparator.compareBytes((byte[])b1, (int)(s1 + n1), (int)(l1 - n1), (byte[])b2, (int)(s2 + n2), (int)(l2 - n2));
        }
    }
}

