/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.commoncrawl.util.shared.Base64;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class S3Utils {
    static final String METADATA_PREFIX = "x-amz-meta-";
    static final String AMAZON_HEADER_PREFIX = "x-amz-";
    static final String ALTERNATIVE_DATE_HEADER = "x-amz-date";
    public static final String DEFAULT_HOST = "s3.amazonaws.com";
    public static final int SECURE_PORT = 443;
    public static final int INSECURE_PORT = 80;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    static String makeCanonicalString(String method, String bucket, String key, Map pathArgs, Map headers) {
        return S3Utils.makeCanonicalString(method, bucket, key, pathArgs, headers, null);
    }

    static String makeCanonicalString(String method, String bucketName, String key, Map pathArgs, Map headers, String expires) {
        StringBuffer buf = new StringBuffer();
        buf.append(method + "\n");
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (String hashKey : headers.keySet()) {
                String lk;
                if (hashKey == null || !(lk = hashKey.toLowerCase()).equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(AMAZON_HEADER_PREFIX)) continue;
                List s = (List)headers.get(hashKey);
                interestingHeaders.put(lk, S3Utils.concatenateList(s));
            }
        }
        if (interestingHeaders.containsKey(ALTERNATIVE_DATE_HEADER)) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (String headerKey : interestingHeaders.keySet()) {
            if (headerKey.startsWith(AMAZON_HEADER_PREFIX)) {
                buf.append(headerKey).append(':').append(interestingHeaders.get(headerKey));
            } else {
                buf.append(interestingHeaders.get(headerKey));
            }
            buf.append("\n");
        }
        if (bucketName != null && !bucketName.equals("")) {
            buf.append("/" + bucketName);
        }
        buf.append("/");
        if (key != null) {
            buf.append(key);
        }
        if (pathArgs != null) {
            if (pathArgs.containsKey("acl")) {
                buf.append("?acl");
            } else if (pathArgs.containsKey("torrent")) {
                buf.append("?torrent");
            } else if (pathArgs.containsKey("logging")) {
                buf.append("?logging");
            } else if (pathArgs.containsKey("location")) {
                buf.append("?location");
            }
        }
        return buf.toString();
    }

    static String encode(String awsSecretAccessKey, String canonicalString, boolean urlencode) {
        SecretKeySpec signingKey = new SecretKeySpec(awsSecretAccessKey.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = null;
        try {
            mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find sha1 algorithm", e);
        }
        try {
            mac.init(signingKey);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Could not initialize the MAC algorithm", e);
        }
        String b64 = Base64.encodeBytes(mac.doFinal(canonicalString.getBytes()));
        if (urlencode) {
            return S3Utils.urlencode(b64);
        }
        return b64;
    }

    static Map paramsForListOptions(String prefix, String marker, Integer maxKeys) {
        return S3Utils.paramsForListOptions(prefix, marker, maxKeys, null);
    }

    static Map paramsForListOptions(String prefix, String marker, Integer maxKeys, String delimiter) {
        HashMap<String, String> argParams = new HashMap<String, String>();
        if (prefix != null) {
            argParams.put("prefix", S3Utils.urlencode(prefix));
        }
        if (marker != null) {
            argParams.put("marker", S3Utils.urlencode(marker));
        }
        if (delimiter != null) {
            argParams.put("delimiter", S3Utils.urlencode(delimiter));
        }
        if (maxKeys != null) {
            argParams.put("max-keys", Integer.toString(maxKeys));
        }
        return argParams;
    }

    public static String convertPathArgsHashToString(Map pathArgs) {
        StringBuffer pathArgsString = new StringBuffer();
        boolean firstRun = true;
        if (pathArgs != null) {
            for (String argument : pathArgs.keySet()) {
                if (firstRun) {
                    firstRun = false;
                    pathArgsString.append("?");
                } else {
                    pathArgsString.append("&");
                }
                String argumentValue = (String)pathArgs.get(argument);
                pathArgsString.append(argument);
                if (argumentValue == null) continue;
                pathArgsString.append("=");
                pathArgsString.append(argumentValue);
            }
        }
        return pathArgsString.toString();
    }

    static String urlencode(String unencoded) {
        try {
            return URLEncoder.encode(unencoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not url encode to UTF-8", e);
        }
    }

    static XMLReader createXMLReader() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e2) {
                throw new RuntimeException("Couldn't initialize a sax driver for the XMLReader");
            }
        }
    }

    private static String concatenateList(List values) {
        StringBuffer buf = new StringBuffer();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            buf.append(((String)values.get(i)).replaceAll("\n", "").trim());
            if (i == size - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    static boolean isValidSubdomainBucketName(String bucketName) {
        int MIN_BUCKET_LENGTH = 3;
        int MAX_BUCKET_LENGTH = 63;
        String IPv4_REGEX = "^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$";
        String BUCKET_NAME_REGEX = "^[a-z0-9]([a-z0-9\\-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-]*[a-z0-9])?)*$";
        return null != bucketName && bucketName.length() >= 3 && bucketName.length() <= 63 && !bucketName.matches("^[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+$") && bucketName.matches("^[a-z0-9]([a-z0-9\\-]*[a-z0-9])?(\\.[a-z0-9]([a-z0-9\\-]*[a-z0-9])?)*$");
    }

    static boolean validateBucketName(String bucketName, CallingFormat callingFormat, boolean located) {
        if (callingFormat == CallingFormat.getPathCallingFormat()) {
            int MIN_BUCKET_LENGTH = 3;
            int MAX_BUCKET_LENGTH = 255;
            String BUCKET_NAME_REGEX = "^[0-9A-Za-z\\.\\-_]*$";
            return null != bucketName && bucketName.length() >= 3 && bucketName.length() <= 255 && bucketName.matches("^[0-9A-Za-z\\.\\-_]*$");
        }
        return S3Utils.isValidSubdomainBucketName(bucketName);
    }

    static CallingFormat getCallingFormatForBucket(CallingFormat desiredFormat, String bucketName) {
        CallingFormat callingFormat = desiredFormat;
        if (callingFormat == CallingFormat.getSubdomainCallingFormat() && !S3Utils.isValidSubdomainBucketName(bucketName)) {
            callingFormat = CallingFormat.getPathCallingFormat();
        }
        return callingFormat;
    }

    public static abstract class CallingFormat {
        protected static CallingFormat pathCallingFormat = new PathCallingFormat();
        protected static CallingFormat subdomainCallingFormat = new SubdomainCallingFormat();
        protected static CallingFormat vanityCallingFormat = new VanityCallingFormat();

        public abstract boolean supportsLocatedBuckets();

        public abstract String getEndpoint(String var1, int var2, String var3);

        public abstract String getPathBase(String var1, String var2);

        public abstract URL getURL(boolean var1, String var2, int var3, String var4, String var5, Map var6) throws MalformedURLException;

        public static CallingFormat getPathCallingFormat() {
            return pathCallingFormat;
        }

        public static CallingFormat getSubdomainCallingFormat() {
            return subdomainCallingFormat;
        }

        public static CallingFormat getVanityCallingFormat() {
            return vanityCallingFormat;
        }

        private static class VanityCallingFormat
        extends SubdomainCallingFormat {
            private VanityCallingFormat() {
            }

            @Override
            public String getServer(String server, String bucket) {
                return bucket;
            }
        }

        private static class SubdomainCallingFormat
        extends CallingFormat {
            private SubdomainCallingFormat() {
            }

            @Override
            public boolean supportsLocatedBuckets() {
                return true;
            }

            public String getServer(String server, String bucket) {
                return bucket + "." + server;
            }

            @Override
            public String getEndpoint(String server, int port, String bucket) {
                return this.getServer(server, bucket) + ":" + port;
            }

            @Override
            public String getPathBase(String bucket, String key) {
                return "/" + key;
            }

            @Override
            public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map pathArgs) throws MalformedURLException {
                if (bucket == null || bucket.length() == 0) {
                    String pathArguments = S3Utils.convertPathArgsHashToString(pathArgs);
                    return new URL(isSecure ? "https" : "http", server, port, "/" + pathArguments);
                }
                String serverToUse = this.getServer(server, bucket);
                String pathBase = this.getPathBase(bucket, key);
                String pathArguments = S3Utils.convertPathArgsHashToString(pathArgs);
                return new URL(isSecure ? "https" : "http", serverToUse, port, pathBase + pathArguments);
            }
        }

        private static class PathCallingFormat
        extends CallingFormat {
            private PathCallingFormat() {
            }

            @Override
            public boolean supportsLocatedBuckets() {
                return false;
            }

            @Override
            public String getPathBase(String bucket, String key) {
                return this.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
            }

            @Override
            public String getEndpoint(String server, int port, String bucket) {
                return server + ":" + port;
            }

            @Override
            public URL getURL(boolean isSecure, String server, int port, String bucket, String key, Map pathArgs) throws MalformedURLException {
                String pathBase = this.isBucketSpecified(bucket) ? "/" + bucket + "/" + key : "/";
                String pathArguments = S3Utils.convertPathArgsHashToString(pathArgs);
                return new URL(isSecure ? "https" : "http", server, port, pathBase + pathArguments);
            }

            private boolean isBucketSpecified(String bucket) {
                if (bucket == null) {
                    return false;
                }
                return bucket.length() != 0;
            }
        }
    }
}

