/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

public class MurmurHash {
    static final int m = 1540483477;
    static final int r = 24;

    public static final int hashInt(int k, int seed) {
        int k1 = k * 1540483477;
        int k2 = k1 ^ k1 >>> 24;
        int k3 = k2 * 1540483477;
        int h1 = seed * 1540483477;
        return h1 ^ k3;
    }

    public static final int hashLong(long k, int seed) {
        int h = MurmurHash.hashInt((int)(k >> 32 & Integer.MAX_VALUE), seed);
        int h2 = MurmurHash.hashInt((int)k, h);
        return h2;
    }

    public static final int hashFloat(float f, int seed) {
        return MurmurHash.hashInt(Float.floatToIntBits(f), seed);
    }

    public static final int hashDouble(double d, int seed) {
        return MurmurHash.hashLong(Double.doubleToLongBits(d), seed);
    }

    public static final int hashBoolean(boolean b, int seed) {
        return MurmurHash.hashInt(b ? 1 : 0, seed);
    }

    public static final int hashString(String s, int seed) {
        byte[] bytes = s.getBytes();
        return MurmurHash.hash(bytes, bytes.length, seed);
    }

    public static final int hash(byte[] data, int length, int seed) {
        return MurmurHash.hash(data, 0, length, seed);
    }

    public static final int hash(byte[] data, int offset, int length, int seed) {
        int h = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = i << 2;
            int k = data[offset + i_4 + 3];
            k <<= 8;
            k |= data[offset + i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[offset + i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[offset + i_4 + 0] & 0xFF;
            k *= 1540483477;
            k ^= k >>> 24;
            h *= 1540483477;
            h ^= (k *= 1540483477);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[offset + length - 3] << 16;
            }
            if (left >= 2) {
                h ^= data[offset + length - 2] << 8;
            }
            if (left >= 1) {
                h ^= data[offset + length - 1];
            }
            h *= 1540483477;
        }
        h ^= h >>> 13;
        h *= 1540483477;
        h ^= h >>> 15;
        return h;
    }
}

