/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunner;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.lib.IdentityMapper;
import org.apache.hadoop.mapred.lib.IdentityReducer;

public class JobBuilder {
    JobConf _jobConf;

    public JobBuilder(String jobName, Configuration conf) {
        this._jobConf = new JobConf(conf);
        this._jobConf.addResource("nutch-default.xml");
        this._jobConf.addResource("nutch-site.xml");
        this._jobConf.setNumTasksToExecutePerJvm(1000);
        this._jobConf.setJobName(jobName);
    }

    public JobBuilder inputs(List<Path> inputs) throws IOException {
        for (Path input : inputs) {
            FileInputFormat.addInputPath((JobConf)this._jobConf, (Path)input);
        }
        return this;
    }

    public JobBuilder input(Path input) throws IOException {
        FileInputFormat.addInputPath((JobConf)this._jobConf, (Path)input);
        return this;
    }

    public JobBuilder output(Path outputPath) throws IOException {
        FileOutputFormat.setOutputPath((JobConf)this._jobConf, (Path)outputPath);
        return this;
    }

    public JobBuilder inputFormat(Class<? extends InputFormat> inputFormat) throws IOException {
        this._jobConf.setInputFormat(inputFormat);
        return this;
    }

    public JobBuilder inputIsSeqFile() throws IOException {
        this._jobConf.setInputFormat(SequenceFileInputFormat.class);
        return this;
    }

    public JobBuilder outputFormat(Class<? extends OutputFormat> outputFormat) throws IOException {
        this._jobConf.setOutputFormat(outputFormat);
        return this;
    }

    public JobBuilder outputIsSeqFile() throws IOException {
        this._jobConf.setOutputFormat(SequenceFileOutputFormat.class);
        return this;
    }

    public JobBuilder jarByClass(Class theClass) throws IOException {
        this._jobConf.setJarByClass(theClass);
        return this;
    }

    public JobBuilder mapper(Class<? extends Mapper> mapper) throws IOException {
        if (mapper != IdentityMapper.class) {
            this._jobConf.setMapperClass(mapper);
        }
        this._jobConf.setJarByClass(mapper);
        return this;
    }

    public JobBuilder mapRunner(Class<? extends MapRunner> mapRunner) throws IOException {
        this._jobConf.setMapRunnerClass(mapRunner);
        this._jobConf.setJarByClass(mapRunner);
        return this;
    }

    public JobBuilder mapperKeyValue(Class<? extends WritableComparable> key, Class<? extends Writable> value) throws IOException {
        this._jobConf.setMapOutputKeyClass(key);
        this._jobConf.setMapOutputValueClass(value);
        this._jobConf.setOutputKeyClass(key);
        this._jobConf.setOutputValueClass(value);
        return this;
    }

    public JobBuilder reducer(Class<? extends Reducer> reducer, boolean hasCombiner) throws IOException {
        if (reducer != IdentityReducer.class) {
            this._jobConf.setReducerClass(reducer);
        }
        if (hasCombiner) {
            this._jobConf.setCombinerClass(reducer);
        }
        this._jobConf.setJarByClass(reducer);
        return this;
    }

    public JobBuilder outputKeyValue(Class<? extends WritableComparable> key, Class<? extends Writable> value) throws IOException {
        this._jobConf.setOutputKeyClass(key);
        this._jobConf.setOutputValueClass(value);
        return this;
    }

    public JobBuilder keyValue(Class<? extends WritableComparable> key, Class<? extends Writable> value) throws IOException {
        this._jobConf.setMapOutputKeyClass(key);
        this._jobConf.setMapOutputValueClass(value);
        this._jobConf.setOutputKeyClass(key);
        this._jobConf.setOutputValueClass(value);
        return this;
    }

    public JobBuilder numMappers(int mappers) throws IOException {
        this._jobConf.setNumMapTasks(mappers);
        return this;
    }

    public JobBuilder numReducers(int reducers) throws IOException {
        this._jobConf.setNumReduceTasks(reducers);
        return this;
    }

    public JobBuilder compressMapOutput(boolean compress) throws IOException {
        this._jobConf.setCompressMapOutput(compress);
        return this;
    }

    public JobBuilder compressor(SequenceFile.CompressionType type, Class<? extends CompressionCodec> codec) throws IOException {
        this._jobConf.setBoolean("mapred.output.compress", true);
        this._jobConf.set("mapred.output.compression.type", type.toString());
        this._jobConf.setClass("mapred.output.compression.codec", codec, CompressionCodec.class);
        return this;
    }

    public JobBuilder compressType(SequenceFile.CompressionType type) throws IOException {
        if (type == SequenceFile.CompressionType.NONE) {
            this._jobConf.setBoolean("mapred.output.compress", false);
        } else {
            this._jobConf.setBoolean("mapred.output.compress", true);
        }
        this._jobConf.set("mapred.output.compression.type", type.toString());
        return this;
    }

    public JobBuilder sort(Class<? extends RawComparator> comparator) throws IOException {
        this._jobConf.setOutputKeyComparatorClass(comparator);
        return this;
    }

    public JobBuilder group(Class<? extends RawComparator> comparator) throws IOException {
        this._jobConf.setOutputValueGroupingComparator(comparator);
        return this;
    }

    public JobBuilder partition(Class<? extends Partitioner> partitioner) throws IOException {
        this._jobConf.setPartitionerClass(partitioner);
        return this;
    }

    public JobBuilder speculativeExecution(boolean enabled) throws IOException {
        this._jobConf.setSpeculativeExecution(enabled);
        return this;
    }

    public JobBuilder speculativeMapExecution() throws IOException {
        this._jobConf.setMapSpeculativeExecution(true);
        return this;
    }

    public JobBuilder speculativeReducerExecution() throws IOException {
        this._jobConf.setReduceSpeculativeExecution(true);
        return this;
    }

    public JobBuilder maxMapAttempts(int maxAttempts) throws IOException {
        this._jobConf.setMaxMapAttempts(maxAttempts);
        return this;
    }

    public JobBuilder maxReduceAttempts(int maxAttempts) throws IOException {
        this._jobConf.setMaxReduceAttempts(maxAttempts);
        return this;
    }

    public JobBuilder delayReducersUntil(float pctMappersComplete) throws IOException {
        this._jobConf.setFloat("mapred.reduce.slowstart.completed.maps", pctMappersComplete);
        return this;
    }

    public JobBuilder maxMapTaskFailures(int percent) throws IOException {
        this._jobConf.setMaxMapTaskFailuresPercent(percent);
        return this;
    }

    public JobBuilder reuseJVM(int numberOfTimes) throws IOException {
        this._jobConf.setNumTasksToExecutePerJvm(numberOfTimes);
        return this;
    }

    public JobBuilder minSplitSize(long minSplitSize) throws IOException {
        this._jobConf.setLong("mapred.min.split.size", minSplitSize);
        return this;
    }

    public JobConf build() throws IOException {
        return this._jobConf;
    }

    public static Path tempDir(Configuration conf, String baseName) throws IOException {
        Path tempOutputDir = new Path(conf.get("mapred.temp.dir", ".") + "/" + baseName + "-" + System.currentTimeMillis());
        return tempOutputDir;
    }

    public JobBuilder set(String key, String value) throws IOException {
        this._jobConf.set(key, value);
        return this;
    }

    public JobBuilder set(String key, long value) throws IOException {
        this._jobConf.setLong(key, value);
        return this;
    }
}

