/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JVMStats {
    private static final Log LOG = LogFactory.getLog(JVMStats.class);
    private static final long MBytes = 0x100000L;
    private static long lastGCTime = 0L;

    public static void dumpMemoryStats() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memHeap = memoryMXBean.getHeapMemoryUsage();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            gcTime += gcBean.getCollectionTime();
        }
        float utilizationRatio = (float)memHeap.getUsed() / (float)memHeap.getMax();
        LOG.info((Object)("Heap Size:" + memHeap.getUsed() / 0x100000L + " (MB) CommitSize:" + memHeap.getCommitted() / 0x100000L + " (MB) Max:" + memHeap.getMax() + " Ratio:" + utilizationRatio + " GCTime:" + (gcTime - lastGCTime) + "PendingFinalCnt:" + memoryMXBean.getObjectPendingFinalizationCount()));
        lastGCTime = gcTime;
    }

    public static float getHeapUtilizationRatio() {
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage memHeap = memoryMXBean.getHeapMemoryUsage();
        return (float)memHeap.getUsed() / (float)memHeap.getMax();
    }
}

