/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.record.Buffer;
import org.commoncrawl.util.shared.FlexBuffer;

public class ImmutableBuffer {
    private FlexBuffer _sourceBuffer;

    public ImmutableBuffer(FlexBuffer buffer) {
        this._sourceBuffer = buffer;
    }

    public InputStream getBytes() {
        return new ByteArrayInputStream(this._sourceBuffer.get(), this._sourceBuffer.getOffset(), this._sourceBuffer.getCount());
    }

    public byte[] getReadOnlyBytes() {
        return this._sourceBuffer.get();
    }

    public FlexBuffer getReadOnlyFlexBuffer() {
        return new FlexBuffer(this._sourceBuffer, true);
    }

    public int getOffset() {
        return this._sourceBuffer.getOffset();
    }

    public int getCount() {
        return this._sourceBuffer.getCount();
    }

    public int getCapacity() {
        return this._sourceBuffer.get().length;
    }

    public int hashCode() {
        return this._sourceBuffer.hashCode();
    }

    public int compareTo(Object other) {
        FlexBuffer otherBuffer = null;
        otherBuffer = other instanceof ImmutableBuffer ? ((ImmutableBuffer)other)._sourceBuffer : (FlexBuffer)other;
        return this._sourceBuffer.compareTo(otherBuffer);
    }

    public boolean equals(Object other) {
        if (other instanceof ImmutableBuffer) {
            return this._sourceBuffer.equals(((ImmutableBuffer)other)._sourceBuffer);
        }
        if (other instanceof Buffer) {
            return this._sourceBuffer.equals((Buffer)other);
        }
        return false;
    }

    public String toString() {
        return this._sourceBuffer.toString();
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return this._sourceBuffer.toString(charsetName);
    }

    public Object clone() throws CloneNotSupportedException {
        FlexBuffer result = (FlexBuffer)this._sourceBuffer.clone();
        return new ImmutableBuffer(result);
    }
}

