/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class IPAddressUtils {
    private static final int INADDR4SZ = 4;

    public static byte[] textToNumericFormatV4(String src) {
        if (src.length() == 0) {
            return null;
        }
        byte[] res = new byte[4];
        String[] s = src.split("\\.", -1);
        try {
            switch (s.length) {
                case 1: {
                    long val = Long.parseLong(s[0]);
                    if (val < 0L || val > 0xFFFFFFFFL) {
                        return null;
                    }
                    res[0] = (byte)(val >> 24 & 0xFFL);
                    res[1] = (byte)((val & 0xFFFFFFL) >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 2: {
                    long val = Integer.parseInt(s[0]);
                    if (val < 0L || val > 255L) {
                        return null;
                    }
                    res[0] = (byte)(val & 0xFFL);
                    val = Integer.parseInt(s[1]);
                    if (val < 0L || val > 0xFFFFFFL) {
                        return null;
                    }
                    res[1] = (byte)(val >> 16 & 0xFFL);
                    res[2] = (byte)((val & 0xFFFFL) >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 3: {
                    long val;
                    for (int i = 0; i < 2; ++i) {
                        val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    val = Integer.parseInt(s[2]);
                    if (val < 0L || val > 65535L) {
                        return null;
                    }
                    res[2] = (byte)(val >> 8 & 0xFFL);
                    res[3] = (byte)(val & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long val = Integer.parseInt(s[i]);
                        if (val < 0L || val > 255L) {
                            return null;
                        }
                        res[i] = (byte)(val & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        return res;
    }

    public static int IPV4AddressStrToInteger(String ipAddressStr) throws UnknownHostException {
        return IPAddressUtils.IPV4AddressToInteger(IPAddressUtils.textToNumericFormatV4(ipAddressStr));
    }

    public static int IPV4AddressToInteger(byte[] addr) {
        int hostAddress = addr[3] & 0xFF;
        hostAddress |= addr[2] << 8 & 0xFF00;
        hostAddress |= addr[1] << 16 & 0xFF0000;
        return hostAddress |= addr[0] << 24 & 0xFF000000;
    }

    public static InetAddress IntegerToInetAddress(int ipAddress) throws UnknownHostException {
        byte[] array = new byte[]{(byte)(ipAddress >> 24 & 0xFF), (byte)(ipAddress >> 16 & 0xFF), (byte)(ipAddress >> 8 & 0xFF), (byte)(ipAddress & 0xFF)};
        return InetAddress.getByAddress(array);
    }

    public static String IntegerToIPAddressString(int ess) {
        String ipAddressOut = "";
        try {
            ipAddressOut = IPAddressUtils.IntegerToInetAddress(ess).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ipAddressOut;
    }
}

