/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.util.Iterator;
import org.commoncrawl.io.shared.NIOHttpHeaders;

public class HttpHeaderUtils {
    public static final String kCharset = "charset=";

    public static void parseContentType(NIOHttpHeaders headers, ContentTypeAndCharset metadataOut) {
        Iterator<String> j = headers.multiValueIterator("content-type");
        while (j.hasNext()) {
            String contentType = j.next();
            if (contentType == null) continue;
            HttpHeaderUtils.parseContentType(metadataOut, contentType);
        }
    }

    static final void parseContentType(ContentTypeAndCharset metadataOut, String contentType) {
        metadataOut.reset();
        int type_val = HttpHeaderUtils.skipPastLWS(contentType, 0);
        type_val = Math.min(type_val, contentType.length());
        int type_end = HttpHeaderUtils.skipToLWSAndExtra(contentType, type_val);
        if (type_end == -1) {
            type_end = contentType.length();
        }
        int charset_val = 0;
        int charset_end = 0;
        boolean type_has_charset = false;
        int param_start = contentType.indexOf(59, type_end);
        if (param_start != -1) {
            int cur_param_end;
            int cur_param_start = param_start + 1;
            do {
                int charset_end_offset;
                if ((cur_param_end = contentType.indexOf(59, cur_param_start)) == -1) {
                    cur_param_end = contentType.length();
                }
                int param_name_start = HttpHeaderUtils.skipPastLWS(contentType, cur_param_start);
                if (!contentType.substring(param_name_start = Math.min(param_name_start, cur_param_end), charset_end_offset = Math.min(param_name_start + kCharset.length(), cur_param_end)).equalsIgnoreCase(kCharset)) continue;
                charset_val = param_name_start + kCharset.length();
                charset_end = cur_param_end;
                type_has_charset = true;
            } while ((cur_param_start = cur_param_end + 1) < contentType.length());
        }
        if (type_has_charset) {
            try {
                charset_val = HttpHeaderUtils.skipPastLWS(contentType, charset_val);
                charset_val = Math.min(charset_val, charset_end);
                if (charset_val == contentType.length()) {
                    type_has_charset = false;
                } else {
                    char first_char = contentType.charAt(charset_val);
                    if (first_char == '\"' || first_char == '\'') {
                        if ((charset_end = contentType.indexOf(first_char, ++charset_val)) == -1) {
                            charset_end = HttpHeaderUtils.skipToLWSAndExtra(contentType, charset_val);
                        }
                    } else {
                        charset_end = Math.min(HttpHeaderUtils.skipToLWSAndExtra(contentType, charset_val), charset_end);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                type_has_charset = false;
            }
        }
        if (contentType.length() != 0 && !contentType.equals("*/*") && contentType.indexOf(47) != -1) {
            String originalContentType = metadataOut._contentType;
            metadataOut._contentType = contentType.substring(type_val, type_end).toLowerCase();
            if (type_has_charset) {
                metadataOut._charset = contentType.substring(charset_val, charset_end).toLowerCase();
            } else if (originalContentType != null && !originalContentType.equals(metadataOut._contentType)) {
                metadataOut._charset = null;
            }
        }
    }

    public static int skipPastLWS(String sourceString, int startPos) {
        char c;
        int endPos;
        for (endPos = startPos; endPos < sourceString.length() && ((c = sourceString.charAt(endPos)) == ' ' || c == '\t'); ++endPos) {
        }
        return endPos;
    }

    public static int skipToLWSAndExtra(String sourceString, int startPos) {
        char c;
        int endPos;
        for (endPos = startPos; endPos < sourceString.length() && (c = sourceString.charAt(endPos)) != ' ' && c != '\t' && c != ';' && c != '('; ++endPos) {
        }
        return endPos;
    }

    public static int parseStatusLine(NIOHttpHeaders headers) {
        String responseLine = headers.getValue(0);
        return HttpHeaderUtils.parseStatusLine(responseLine);
    }

    public static int parseStatusLine(String responseLine) {
        int indexOfDot;
        if (responseLine == null || responseLine.length() < 4) {
            return 200;
        }
        if (!(responseLine = responseLine.toLowerCase()).startsWith("http")) {
            return 200;
        }
        boolean versionValid = false;
        if ((responseLine.length() > 4 || responseLine.charAt(4) == '/') && ((indexOfDot = responseLine.indexOf(".", 5)) != -1 && indexOfDot != 5 || indexOfDot + 1 < responseLine.length())) {
            char majorVersionChar = responseLine.charAt(5);
            char minorVersionChar = responseLine.charAt(indexOfDot + 1);
            if (majorVersionChar >= '0' && majorVersionChar <= '9' && minorVersionChar >= '0' && minorVersionChar <= '9') {
                int majorVersion = majorVersionChar - 48;
                int minorVersion = minorVersionChar - 48;
                if (majorVersion == 1 && minorVersion == 0 || majorVersion != 1 || minorVersion == 1) {
                    // empty if block
                }
                versionValid = true;
                int spaceIndex = responseLine.indexOf(32, indexOfDot + 1);
                if (spaceIndex + 1 < responseLine.length()) {
                    int digitStart;
                    char c;
                    int digitEnd;
                    for (digitEnd = digitStart = spaceIndex + 1; digitEnd < responseLine.length() && (c = responseLine.charAt(digitEnd)) >= '0' && c <= '9'; ++digitEnd) {
                    }
                    if (digitEnd - digitStart != 0) {
                        try {
                            return Integer.parseInt(responseLine.substring(digitStart, digitEnd));
                        }
                        catch (NumberFormatException e) {
                            return 0;
                        }
                    }
                }
            }
        }
        return 200;
    }

    public static class ContentTypeAndCharset {
        public String _contentType = null;
        public String _charset = null;

        void reset() {
            this._contentType = null;
            this._charset = null;
        }
    }
}

