/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.file.tfile.RawComparable;
import org.commoncrawl.util.shared.BinaryComparableWithOffset;

public final class FlexBuffer
extends BinaryComparableWithOffset
implements WritableComparable<BinaryComparable>,
RawComparator<FlexBuffer>,
RawComparable,
Cloneable {
    int count;
    byte[] zbytes = null;
    int offset = 0;
    boolean _isShared = false;

    public FlexBuffer() {
        this.count = 0;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public FlexBuffer(FlexBuffer other, boolean shared) {
        this.count = other.count;
        this.zbytes = other.zbytes;
        this.offset = other.offset;
        this._isShared = shared;
        other._isShared = true;
    }

    public FlexBuffer(byte[] bytes, boolean shared) {
        this.set(bytes, shared);
    }

    public FlexBuffer(byte[] bytes, int offset, int length, boolean shared) {
        this.set(bytes, offset, length, shared);
    }

    public void set(byte[] bytes, boolean shared) {
        this.count = bytes == null ? 0 : bytes.length;
        this.zbytes = bytes;
        this.offset = 0;
        this._isShared = true;
    }

    public void set(byte[] bytes, int offset, int length, boolean shared) {
        this.count = length;
        this.zbytes = bytes;
        this.offset = offset;
        this._isShared = shared;
    }

    public final void copy(byte[] bytes, int offset, int length) {
        if (this.zbytes == null || this.zbytes.length - offset < length) {
            this.zbytes = new byte[length];
            this.offset = 0;
            this._isShared = false;
        }
        if (this._isShared) {
            this.copyOnWrite();
        }
        System.arraycopy(bytes, offset, this.zbytes, this.offset, length);
        this.count = length;
    }

    public byte[] get() {
        if (this.zbytes == null) {
            this.zbytes = new byte[0];
            this.offset = 0;
        }
        return this.zbytes;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        if (this.getCapacity() < count) {
            this.setCapacity(count);
        }
        this.count = count;
    }

    public int getCapacity() {
        return this.get().length - this.offset;
    }

    public void setCapacity(int newCapacity) {
        if (newCapacity < 0) {
            throw new IllegalArgumentException("Invalid capacity argument " + newCapacity);
        }
        if (newCapacity == 0) {
            this.zbytes = null;
            this.count = 0;
            this.offset = 0;
            this._isShared = false;
            return;
        }
        if (newCapacity != this.getCapacity()) {
            byte[] data = new byte[newCapacity];
            if (newCapacity < this.count) {
                this.count = newCapacity;
            }
            if (this.count != 0) {
                System.arraycopy(this.get(), this.offset, data, 0, this.count);
            }
            this.zbytes = data;
            this.offset = 0;
            this._isShared = false;
        } else {
            this.copyOnWrite();
        }
    }

    public void reset() {
        this.setCapacity(0);
    }

    public void truncate() {
        this.setCapacity(this.count);
    }

    public void append(byte[] bytes, int offset, int length) {
        this.setCapacity(this.count + length);
        System.arraycopy(bytes, offset, this.get(), offset + this.count, length);
        this.count += length;
    }

    public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    public int hashCode() {
        int hash = 1;
        byte[] b = this.get();
        for (int i = 0; i < this.count; ++i) {
            hash = 31 * hash + b[this.offset + i];
        }
        return hash;
    }

    public int compareTo(FlexBuffer other) {
        return BytesWritable.Comparator.compareBytes((byte[])this.zbytes, (int)this.offset, (int)this.count, (byte[])other.zbytes, (int)other.offset, (int)other.count);
    }

    public boolean equals(Object other) {
        if (other instanceof FlexBuffer && this != other) {
            return this.compareTo((FlexBuffer)other) == 0;
        }
        return this == other;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(2 * this.count);
        for (int idx = this.offset; idx < this.count + this.offset; ++idx) {
            sb.append(Character.forDigit((this.zbytes[idx] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(this.zbytes[idx] & 0xF, 16));
        }
        return sb.toString();
    }

    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.get(), this.offset, this.getCount(), charsetName);
    }

    public Object clone() throws CloneNotSupportedException {
        FlexBuffer result = new FlexBuffer();
        result.copy(this.get(), this.offset, this.getCount());
        return result;
    }

    public void copyOnWrite() {
        if (this._isShared) {
            if (this.zbytes != null) {
                int actualSize = this.zbytes.length - this.offset;
                byte[] data = null;
                if (actualSize != 0) {
                    data = new byte[actualSize];
                    if (this.count != 0) {
                        System.arraycopy(this.zbytes, this.offset, data, 0, this.count);
                    }
                }
                this.zbytes = data;
                this.offset = 0;
            }
            this._isShared = false;
        }
    }

    public void readFields(DataInput in) throws IOException {
        int byteCount = WritableUtils.readVInt((DataInput)in);
        this.setCount(0);
        this.setCount(byteCount);
        if (byteCount != 0) {
            this.copyOnWrite();
            in.readFully(this.get(), this.getOffset(), byteCount);
        }
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.getCount());
        if (this.getCount() != 0) {
            out.write(this.get(), this.getOffset(), this.getCount());
        }
    }

    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        return BytesWritable.Comparator.compareBytes((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2);
    }

    public int compare(FlexBuffer o1, FlexBuffer o2) {
        return o1.compareTo(o2);
    }

    public byte[] buffer() {
        return this.zbytes;
    }

    public int offset() {
        return this.offset;
    }

    public int size() {
        return this.count;
    }

    public byte[] getBytes() {
        return this.zbytes;
    }

    public int getLength() {
        return this.count;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }
}

