/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;

public class FileUtils
extends FileUtil {
    private static final int ID_MAX = 100000000;
    private static final int SCALE_FACTOR = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFully(File path) throws IOException {
        byte[] dataBuffer = new byte[(int)path.length()];
        FileInputStream fileInputStream = new FileInputStream(path);
        try {
            int chunkSize = 0x4000000;
            int bytesRemaining = (int)path.length();
            int offset = 0;
            while (bytesRemaining != 0) {
                int bytesToRead = Math.min(bytesRemaining, chunkSize);
                fileInputStream.read(dataBuffer, offset, bytesToRead);
                bytesRemaining -= bytesToRead;
                offset += bytesToRead;
            }
        }
        finally {
            fileInputStream.close();
        }
        return dataBuffer;
    }

    public static boolean recursivelyDeleteFile(File path) {
        File[] files;
        if (path.exists() && path.isDirectory() && (files = path.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtils.recursivelyDeleteFile(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static File buildHierarchicalPathForId(File basePath, long fileId) {
        File pathOut = basePath;
        int value = Math.abs((int)(fileId % 100000000L));
        for (int divisor = 1000000; divisor >= 1; divisor /= 100) {
            if (divisor != 1) {
                pathOut = new File(pathOut, Integer.toString(value / divisor));
                value %= divisor;
                continue;
            }
            pathOut = new File(pathOut, Long.toString(fileId));
            break;
        }
        return pathOut;
    }
}

