/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import org.apache.log4j.helpers.AppenderAttachableImpl;
import org.apache.log4j.helpers.BoundedFIFO;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.commoncrawl.util.shared.AsyncAppender;

class Dispatcher
extends Thread {
    BoundedFIFO bf;
    AppenderAttachableImpl aai;
    boolean interrupted = false;
    AsyncAppender container;

    Dispatcher(BoundedFIFO bf, AsyncAppender container) {
        this.bf = bf;
        this.container = container;
        this.aai = container.aai;
        this.setDaemon(true);
        this.setPriority(1);
        this.setName("Dispatcher-" + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        BoundedFIFO boundedFIFO = this.bf;
        synchronized (boundedFIFO) {
            this.interrupted = true;
            if (this.bf.length() == 0) {
                this.bf.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            LoggingEvent event;
            BoundedFIFO boundedFIFO = this.bf;
            synchronized (boundedFIFO) {
                if (this.bf.length() == 0) {
                    if (this.interrupted) {
                        break;
                    }
                    try {
                        this.bf.wait();
                    }
                    catch (InterruptedException e) {
                        LogLog.error((String)"The dispathcer should not be interrupted.");
                        break;
                    }
                }
                event = this.bf.get();
                if (this.bf.wasFull()) {
                    this.bf.notify();
                }
            }
            boundedFIFO = this.container.aai;
            synchronized (boundedFIFO) {
                if (this.aai != null && event != null) {
                    this.aai.appendLoopOnAppenders(event);
                }
            }
        }
        this.aai.removeAllAppenders();
    }
}

