/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

public class ByteArrayUtils {
    public static final int indexOf(byte[] data, int offset, int length, byte[] pattern) {
        int[] failure = ByteArrayUtils.computeFailure(pattern);
        int j = 0;
        for (int i = 0; i < length; ++i) {
            while (j > 0 && pattern[j] != data[offset + i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[offset + i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return offset + (i - pattern.length + 1);
        }
        return -1;
    }

    private static final int[] computeFailure(byte[] pattern) {
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }

    public static long parseLong(byte[] s, int offset, int length, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = length;
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = (char)s[offset];
            if (firstChar < '0') {
                if (firstChar != '-') {
                    throw new NumberFormatException();
                }
                negative = true;
                limit = Long.MIN_VALUE;
                if (len == 1) {
                    throw new NumberFormatException();
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit((char)s[offset + i++], radix)) < 0) {
                    throw new NumberFormatException();
                }
                if (result < multmin) {
                    throw new NumberFormatException();
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw new NumberFormatException();
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException();
        }
        return negative ? result : -result;
    }
}

