/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

public class BandwidthUtils {

    public static class RateLimiter {
        private int _desiredBandwidthBytes;
        private BandwidthHistory _history = new BandwidthHistory();
        private long _windowStartTime;
        private int _bytesAccumulated;

        public RateLimiter(int maxBitsPerSecond) {
            this._desiredBandwidthBytes = maxBitsPerSecond / 8;
        }

        public int checkRateLimit(int byteAvailable) {
            long currentTime = System.currentTimeMillis();
            if (this._windowStartTime == 0L || currentTime - this._windowStartTime >= 1000L) {
                this._windowStartTime = currentTime;
                this._bytesAccumulated = 0;
            }
            return Math.min(this._desiredBandwidthBytes - this._bytesAccumulated, byteAvailable);
        }

        public void updateStats(int bytesInOrOut) {
            this._bytesAccumulated += bytesInOrOut;
            this._history.update(bytesInOrOut);
        }

        public void getStats(BandwidthStats bandwidthStats) {
            this._history.calcSpeed(bandwidthStats);
        }
    }

    public static class BandwidthHistory {
        private static final int SPEED_HISTORY_SIZE = 20;
        private static final int SPEED_SAMPLE_MIN = 150;
        private static final int STALL_START_TIME = 5000;
        private static String[] byte_units = new String[]{"B/s", "KB/s", "MB/s", "GB/s"};
        private static String[] bit_units = new String[]{"b/s", "Kb/s", "Mb/s", "Gb/s"};
        int pos;
        int[] times = new int[20];
        int[] bytes = new int[20];
        int total_time;
        int total_bytes;
        int recent_bytes;
        long recent_start;
        boolean stalled = false;

        private void reset() {
            this.pos = 0;
            this.recent_bytes = 0;
            this.times[0] = 0;
            this.bytes[0] = 0;
            this.total_time = 0;
            this.total_bytes = 0;
        }

        public void update(int bytesUploaded) {
            if (this.recent_start == 0L) {
                this.recent_start = System.currentTimeMillis();
            }
            long currTime = System.currentTimeMillis();
            int recentAge = (int)(currTime - this.recent_start);
            this.recent_bytes += bytesUploaded;
            if (recentAge < 150) {
                return;
            }
            if (bytesUploaded == 0) {
                if (recentAge >= 5000) {
                    this.stalled = true;
                    this.reset();
                }
                return;
            }
            if (this.stalled) {
                this.stalled = false;
                recentAge = 1;
            }
            this.total_time -= this.times[this.pos];
            this.total_bytes -= this.bytes[this.pos];
            this.times[this.pos] = recentAge;
            this.bytes[this.pos] = this.recent_bytes;
            this.total_time += recentAge;
            this.total_bytes += this.recent_bytes;
            this.recent_start = currTime;
            this.recent_bytes = 0;
            if (++this.pos == 20) {
                this.pos = 0;
            }
        }

        public void calcSpeed(BandwidthStats statsOut) {
            int downloadAmount = this.total_bytes + this.recent_bytes;
            int downloadTime = this.total_time;
            if (this.recent_start != 0L && !this.stalled) {
                downloadTime += (int)(System.currentTimeMillis() - this.recent_start);
            }
            if (downloadAmount != 0 && downloadTime != 0) {
                statsOut.bytesPerSecond = (double)downloadAmount / ((double)downloadTime / 1000.0);
                statsOut.bitsPerSecond = statsOut.bytesPerSecond * 8.0;
                if (statsOut.bytesPerSecond < 1024.0) {
                    statsOut.scaledBytesPerSecond = statsOut.bytesPerSecond;
                    statsOut.scaledBytesUnits = byte_units[0];
                } else if (statsOut.bytesPerSecond < 1048576.0) {
                    statsOut.scaledBytesPerSecond = statsOut.bytesPerSecond / 1024.0;
                    statsOut.scaledBytesUnits = byte_units[1];
                } else if (statsOut.bytesPerSecond < 1.073741824E9) {
                    statsOut.scaledBytesPerSecond = statsOut.bytesPerSecond / 1048576.0;
                    statsOut.scaledBytesUnits = byte_units[2];
                } else {
                    statsOut.scaledBytesPerSecond = statsOut.bytesPerSecond / 1.073741824E9;
                    statsOut.scaledBytesUnits = byte_units[3];
                }
                if (statsOut.bitsPerSecond < 1024.0) {
                    statsOut.scaledBitsPerSecond = statsOut.bitsPerSecond;
                    statsOut.scaledBitsUnits = bit_units[0];
                } else if (statsOut.bitsPerSecond < 1048576.0) {
                    statsOut.scaledBitsPerSecond = statsOut.bitsPerSecond / 1024.0;
                    statsOut.scaledBitsUnits = bit_units[1];
                } else if (statsOut.bitsPerSecond < 1.073741824E9) {
                    statsOut.scaledBitsPerSecond = statsOut.bitsPerSecond / 1048576.0;
                    statsOut.scaledBitsUnits = bit_units[2];
                } else {
                    statsOut.scaledBitsPerSecond = statsOut.bitsPerSecond / 1.073741824E9;
                    statsOut.scaledBitsUnits = bit_units[3];
                }
            }
        }
    }

    public static class BandwidthStats {
        public double bitsPerSecond = 0.0;
        public double bytesPerSecond = 0.0;
        public double scaledBytesPerSecond = 0.0;
        public String scaledBytesUnits;
        public double scaledBitsPerSecond = 0.0;
        public String scaledBitsUnits;
    }
}

