/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStructWithId;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class UnitTestStruct1
extends RPCStructWithId<UnitTestStruct1>
implements Writable {
    public static final int Field_INTTYPE = 1;
    public static final int Field_LONGTYPE = 2;
    public static final int Field_STRINGTYPE = 3;
    public static final int Field_VECTOROFSTRINGS = 4;
    static final int FieldID_MAX = 4;
    private BitSet __validFields = new BitSet(5);
    private int intType;
    private long longType;
    private TextBytes stringType = new TextBytes();
    private ArrayList<TextBytes> vectorOfStrings = new ArrayList();

    public static UnitTestStruct1 newInstance(Configuration conf) {
        return (UnitTestStruct1)ReflectionUtils.newInstance(UnitTestStruct1.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final UnitTestStruct1 setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final UnitTestStruct1 setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public int getIntType() {
        return this.intType;
    }

    public UnitTestStruct1 setIntType(int intType) {
        this.__validFields.set(1);
        this.intType = intType;
        return this;
    }

    public long getLongType() {
        return this.longType;
    }

    public UnitTestStruct1 setLongType(long longType) {
        this.__validFields.set(2);
        this.longType = longType;
        return this;
    }

    public TextBytes getStringTypeAsTextBytes() {
        return this.stringType;
    }

    public String getStringType() {
        return this.stringType.toString();
    }

    public UnitTestStruct1 setStringType(String stringType) {
        this.__validFields.set(3);
        this.stringType.set(stringType);
        return this;
    }

    public ArrayList<TextBytes> getVectorOfStrings() {
        return this.vectorOfStrings;
    }

    public UnitTestStruct1 setVectorOfStrings(ArrayList<TextBytes> vectorOfStrings) {
        this.__validFields.set(4);
        this.vectorOfStrings = vectorOfStrings;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty;
        boolean bl = isDirty = !this.__validFields.isEmpty();
        if (!isDirty && !isDirty) {
            isDirty = this.vectorOfStrings.size() != 0;
        }
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "intType", 1);
            encoder.writeInt(output, this.intType);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "longType", 2);
            encoder.writeLong(output, this.longType);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "stringType", 3);
            encoder.writeTextBytes(output, this.stringType);
        }
        if (this.vectorOfStrings.size() != 0) {
            this.__validFields.set(4);
            encoder.beginField(output, "vectorOfStrings", 4);
            int len1 = this.vectorOfStrings.size();
            encoder.writeInt(output, len1);
            for (int vidx1 = 0; vidx1 < len1; ++vidx1) {
                TextBytes e1 = this.vectorOfStrings.get(vidx1);
                encoder.writeTextBytes(output, e1);
            }
        } else {
            this.__validFields.clear(4);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.intType = decoder.readInt(input);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    this.longType = decoder.readLong(input);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    decoder.readTextBytes(input, this.stringType);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    int itemCount1 = decoder.readInt(input);
                    this.vectorOfStrings = new ArrayList();
                    for (int i1 = 0; i1 < itemCount1; ++i1) {
                        TextBytes e1 = new TextBytes();
                        decoder.readTextBytes(input, e1);
                        this.vectorOfStrings.add(e1);
                    }
                    break;
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    @Override
    public final void clear() {
        super.clear();
        this.__validFields.clear();
        this.intType = 0;
        this.longType = 0L;
        this.stringType.clear();
        this.vectorOfStrings.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof UnitTestStruct1)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        UnitTestStruct1 peer = (UnitTestStruct1)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.intType == peer.intType;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(2)) {
            boolean bl = ret = this.longType == peer.longType;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(3) && !(ret = this.stringType.equals(peer.stringType))) {
            return ret;
        }
        if (this.vectorOfStrings.size() != 0 && !(ret = this.vectorOfStrings.equals(peer.vectorOfStrings))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        UnitTestStruct1 other = new UnitTestStruct1();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.intType = this.intType;
        }
        if (this.__validFields.get(2)) {
            other.longType = this.longType;
        }
        if (this.__validFields.get(3)) {
            other.stringType = (TextBytes)this.stringType.clone();
        }
        other.vectorOfStrings = new ArrayList();
        int len0 = this.vectorOfStrings.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            TextBytes src0 = this.vectorOfStrings.get(vidx0);
            TextBytes tgt0 = (TextBytes)src0.clone();
            other.vectorOfStrings.add(tgt0);
        }
        return other;
    }

    @Override
    public final void merge(UnitTestStruct1 peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.intType = peer.intType;
        }
        if (peer.__validFields.get(2)) {
            this.longType = peer.longType;
        }
        if (peer.__validFields.get(3)) {
            this.stringType = (TextBytes)peer.stringType.clone();
        }
        int len0 = peer.vectorOfStrings.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            TextBytes src0 = peer.vectorOfStrings.get(vidx0);
            TextBytes tgt0 = (TextBytes)src0.clone();
            this.vectorOfStrings.add(tgt0);
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashInt(this.intType, result);
        result = MurmurHash.hashLong(this.longType, result);
        result = MurmurHash.hash(this.stringType.getBytes(), this.stringType.getOffset(), this.stringType.getLength(), result);
        result = MurmurHash.hashInt(this.vectorOfStrings.hashCode(), result);
        return result;
    }

    public static final class EnumeratedValue {
        public static final int ONE = 1;
        public static final int TWO = 2;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "ONE";
                }
                case 2: {
                    return "TWO";
                }
            }
            return "";
        }
    }
}

