/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.rpc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.io.internal.NIOClientSocket;
import org.commoncrawl.io.internal.NIOClientTCPSocket;
import org.commoncrawl.io.internal.NIOServerSocketListener;
import org.commoncrawl.io.internal.NIOServerTCPSocket;
import org.commoncrawl.io.internal.NIOSocket;
import org.commoncrawl.rpc.RPCActorService;
import org.commoncrawl.rpc.RPCChannel;
import org.commoncrawl.rpc.RPCException;
import org.commoncrawl.rpc.RPCFrame;

public class RPCServerChannel
implements NIOServerSocketListener {
    private static int INITIAL_RECONNECT_DELAY = 1000;
    InetSocketAddress _address;
    EventLoop _eventLoop;
    NIOServerTCPSocket _socket;
    Timer _reconnectTimer = null;
    int _reconnectDelay = 0;
    RPCActorService _server;
    LinkedList<RPCChannel> _activeClients = new LinkedList();
    ConnectionCallback _callback;
    State _state = State.CLOSED;

    public RPCServerChannel(RPCActorService server, EventLoop eventLoop, InetSocketAddress address, ConnectionCallback callback) {
        this._address = address;
        this._eventLoop = eventLoop;
        this._server = server;
        this._callback = callback;
    }

    public void open() throws IOException {
        if (this._state == State.CLOSED) {
            this.rebind();
        }
    }

    public void close() {
        if (this._state != State.CLOSED) {
            this.release();
        }
    }

    void rebind() throws IOException {
        this.release();
        if (this._reconnectDelay == 0) {
            this._reconnectDelay = INITIAL_RECONNECT_DELAY;
            this.bind();
        } else {
            this._reconnectTimer = new Timer(this._reconnectDelay, false, new Timer.Callback(){

                @Override
                public void timerFired(Timer timer) {
                    try {
                        RPCServerChannel.this.bind();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            RPCServerChannel.this.rebind();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            this._eventLoop.setTimer(this._reconnectTimer);
        }
    }

    void bind() throws IOException {
        this._reconnectDelay *= 2;
        this._reconnectTimer = null;
        if (this._socket == null) {
            this._socket = new NIOServerTCPSocket(this);
            this._socket.open(this._address);
            this._eventLoop.getSelector().registerForAccept(this._socket);
            this._state = State.OPEN_CONNECTED;
        }
    }

    void release() {
        if (this._reconnectTimer != null) {
            this._eventLoop.cancelTimer(this._reconnectTimer);
            this._reconnectTimer = null;
        }
        if (this._socket != null) {
            this._eventLoop.getSelector().cancelRegistration(this._socket);
            this._socket.close();
            this._socket = null;
        }
        for (RPCChannel client : this._activeClients) {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
        this._activeClients.clear();
        this._state = State.CLOSED;
    }

    RPCActorService getServer() {
        return this._server;
    }

    @Override
    public void Accepted(NIOClientSocket newClientSocket) throws IOException {
        RPCChannel newChannel = new RPCChannel((NIOClientTCPSocket)newClientSocket, this);
        this._activeClients.add(newChannel);
        if (this._callback != null) {
            this._callback.IncomingClientConnected(newChannel);
        }
    }

    @Override
    public void Disconnected(NIOSocket theSocket, Exception disconnectReason) throws IOException {
    }

    void ClientChannelDisconnected(RPCChannel channel) {
        if (this._callback != null) {
            this._callback.IncomingClientDisconnected(channel);
        }
        this._activeClients.remove(channel);
    }

    final void dispatchRequest(RPCChannel source, RPCFrame.IncomingFrame frame) throws RPCException {
        this.getServer().dispatchWireRequest(this, source, frame);
    }

    @Override
    public void Excepted(NIOSocket socket, Exception e) {
    }

    private static enum State {
        OPEN,
        OPEN_CONNECTED,
        CLOSED;

    }

    public static interface ConnectionCallback {
        public void IncomingClientConnected(RPCChannel var1);

        public void IncomingClientDisconnected(RPCChannel var1);
    }
}

