/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.query.QueryStatus;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;

public class SlaveStatus
extends RPCStruct<SlaveStatus>
implements Writable {
    public static final int Field_STATE = 1;
    public static final int Field_QUERYSTATUS = 2;
    static final int FieldID_MAX = 2;
    private BitSet __validFields = new BitSet(3);
    private int state;
    private ArrayList<QueryStatus> queryStatus = new ArrayList();

    public static SlaveStatus newInstance(Configuration conf) {
        return (SlaveStatus)ReflectionUtils.newInstance(SlaveStatus.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final SlaveStatus setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final SlaveStatus setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public int getState() {
        return this.state;
    }

    public SlaveStatus setState(int state) {
        this.__validFields.set(1);
        this.state = state;
        return this;
    }

    public ArrayList<QueryStatus> getQueryStatus() {
        return this.queryStatus;
    }

    public SlaveStatus setQueryStatus(ArrayList<QueryStatus> queryStatus) {
        this.__validFields.set(2);
        this.queryStatus = queryStatus;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty;
        boolean bl = isDirty = !this.__validFields.isEmpty();
        if (!isDirty && !isDirty) {
            isDirty = this.queryStatus.size() != 0;
        }
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "state", 1);
            encoder.writeInt(output, this.state);
        }
        if (this.queryStatus.size() != 0) {
            this.__validFields.set(2);
            encoder.beginField(output, "queryStatus", 2);
            int len1 = this.queryStatus.size();
            encoder.writeInt(output, len1);
            for (int vidx1 = 0; vidx1 < len1; ++vidx1) {
                QueryStatus e1 = this.queryStatus.get(vidx1);
                e1.serialize(output, encoder);
            }
        } else {
            this.__validFields.clear(2);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.state = decoder.readInt(input);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    int itemCount1 = decoder.readInt(input);
                    this.queryStatus = new ArrayList();
                    for (int i1 = 0; i1 < itemCount1; ++i1) {
                        QueryStatus e1 = new QueryStatus();
                        e1.deserialize(input, decoder);
                        this.queryStatus.add(e1);
                    }
                    break;
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.state = 0;
        this.queryStatus.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof SlaveStatus)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        SlaveStatus peer = (SlaveStatus)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.state == peer.state;
            if (!ret) {
                return ret;
            }
        }
        if (this.queryStatus.size() != 0 && !(ret = this.queryStatus.equals(peer.queryStatus))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        SlaveStatus other = new SlaveStatus();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.state = this.state;
        }
        other.queryStatus = new ArrayList();
        int len0 = this.queryStatus.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            QueryStatus src0 = this.queryStatus.get(vidx0);
            QueryStatus tgt0 = (QueryStatus)src0.clone();
            other.queryStatus.add(tgt0);
        }
        return other;
    }

    @Override
    public final void merge(SlaveStatus peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.state = peer.state;
        }
        int len0 = peer.queryStatus.size();
        for (int vidx0 = 0; vidx0 < len0; ++vidx0) {
            QueryStatus src0 = peer.queryStatus.get(vidx0);
            QueryStatus tgt0 = (QueryStatus)src0.clone();
            this.queryStatus.add(tgt0);
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashInt(this.state, result);
        result = MurmurHash.hashInt(this.queryStatus.hashCode(), result);
        return result;
    }

    public static final class State {
        public static final int INITIALIZING = 1;
        public static final int READY = 2;
        public static final int ERROR = 10;

        public static String toString(int enumValue) {
            switch (enumValue) {
                case 1: {
                    return "INITIALIZING";
                }
                case 2: {
                    return "READY";
                }
                case 10: {
                    return "ERROR";
                }
            }
            return "";
        }
    }
}

