/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.query.ClientQueryInfo;
import org.commoncrawl.query.QueryCommon;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.FlexBuffer;
import org.commoncrawl.util.shared.ImmutableBuffer;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class RemoteQueryInfo
extends RPCStruct<RemoteQueryInfo>
implements Writable {
    public static final int Field_COMMONINFO = 1;
    public static final int Field_QUERYCLASSTYPE = 2;
    public static final int Field_QUERYDATACLASSTYPE = 3;
    public static final int Field_QUERYDATABUFFER = 4;
    public static final int Field_CLIENTQUERYDATA = 5;
    public static final int Field_SHARDID = 6;
    static final int FieldID_MAX = 6;
    private BitSet __validFields = new BitSet(7);
    private QueryCommon commonInfo = new QueryCommon();
    private TextBytes queryClassType = new TextBytes();
    private TextBytes queryDataClassType = new TextBytes();
    private FlexBuffer queryDataBuffer = new FlexBuffer();
    private ClientQueryInfo clientQueryData = new ClientQueryInfo();
    private int shardId;

    public static RemoteQueryInfo newInstance(Configuration conf) {
        return (RemoteQueryInfo)ReflectionUtils.newInstance(RemoteQueryInfo.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final RemoteQueryInfo setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final RemoteQueryInfo setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public QueryCommon getCommonInfo() {
        return this.commonInfo;
    }

    public RemoteQueryInfo setCommonInfo(QueryCommon commonInfo) {
        this.__validFields.set(1);
        this.commonInfo = commonInfo;
        return this;
    }

    public TextBytes getQueryClassTypeAsTextBytes() {
        return this.queryClassType;
    }

    public String getQueryClassType() {
        return this.queryClassType.toString();
    }

    public RemoteQueryInfo setQueryClassType(String queryClassType) {
        this.__validFields.set(2);
        this.queryClassType.set(queryClassType);
        return this;
    }

    public TextBytes getQueryDataClassTypeAsTextBytes() {
        return this.queryDataClassType;
    }

    public String getQueryDataClassType() {
        return this.queryDataClassType.toString();
    }

    public RemoteQueryInfo setQueryDataClassType(String queryDataClassType) {
        this.__validFields.set(3);
        this.queryDataClassType.set(queryDataClassType);
        return this;
    }

    public ImmutableBuffer getQueryDataBuffer() {
        return new ImmutableBuffer(this.queryDataBuffer);
    }

    public RemoteQueryInfo setQueryDataBuffer(FlexBuffer queryDataBuffer) {
        this.__validFields.set(4);
        this.queryDataBuffer = queryDataBuffer;
        return this;
    }

    public RemoteQueryInfo setQueryDataBuffer(Buffer queryDataBuffer, boolean shared) {
        this.__validFields.set(4);
        this.queryDataBuffer = new FlexBuffer(queryDataBuffer.get(), 0, queryDataBuffer.getCount(), shared);
        return this;
    }

    public ClientQueryInfo getClientQueryData() {
        return this.clientQueryData;
    }

    public RemoteQueryInfo setClientQueryData(ClientQueryInfo clientQueryData) {
        this.__validFields.set(5);
        this.clientQueryData = clientQueryData;
        return this;
    }

    public int getShardId() {
        return this.shardId;
    }

    public RemoteQueryInfo setShardId(int shardId) {
        this.__validFields.set(6);
        this.shardId = shardId;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty;
        boolean bl = isDirty = !this.__validFields.isEmpty();
        if (!isDirty) {
            if (!isDirty) {
                isDirty = this.commonInfo.isObjectDirty();
            }
            if (!isDirty) {
                isDirty = this.clientQueryData.isObjectDirty();
            }
        }
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.commonInfo.isObjectDirty()) {
            this.__validFields.set(1);
            encoder.beginField(output, "commonInfo", 1);
            this.commonInfo.serialize(output, encoder);
        } else {
            this.__validFields.clear(1);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "queryClassType", 2);
            encoder.writeTextBytes(output, this.queryClassType);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "queryDataClassType", 3);
            encoder.writeTextBytes(output, this.queryDataClassType);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "queryDataBuffer", 4);
            encoder.writeFlexBuffer(output, this.queryDataBuffer);
        }
        if (this.clientQueryData.isObjectDirty()) {
            this.__validFields.set(5);
            encoder.beginField(output, "clientQueryData", 5);
            this.clientQueryData.serialize(output, encoder);
        } else {
            this.__validFields.clear(5);
        }
        if (this.__validFields.get(6)) {
            encoder.beginField(output, "shardId", 6);
            encoder.writeInt(output, this.shardId);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.commonInfo = new QueryCommon();
                    this.commonInfo.deserialize(input, decoder);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    decoder.readTextBytes(input, this.queryClassType);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    decoder.readTextBytes(input, this.queryDataClassType);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    decoder.readFlexBuffer(input, this.queryDataBuffer);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    this.clientQueryData = new ClientQueryInfo();
                    this.clientQueryData.deserialize(input, decoder);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    this.shardId = decoder.readInt(input);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.commonInfo.clear();
        this.queryClassType.clear();
        this.queryDataClassType.clear();
        this.queryDataBuffer.reset();
        this.clientQueryData.clear();
        this.shardId = 0;
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof RemoteQueryInfo)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        RemoteQueryInfo peer = (RemoteQueryInfo)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.commonInfo.isObjectDirty() && !(ret = this.commonInfo.equals(peer.commonInfo))) {
            return ret;
        }
        if (this.__validFields.get(2) && !(ret = this.queryClassType.equals(peer.queryClassType))) {
            return ret;
        }
        if (this.__validFields.get(3) && !(ret = this.queryDataClassType.equals(peer.queryDataClassType))) {
            return ret;
        }
        if (this.__validFields.get(4) && !(ret = this.queryDataBuffer.equals(peer.queryDataBuffer))) {
            return ret;
        }
        if (this.clientQueryData.isObjectDirty() && !(ret = this.clientQueryData.equals(peer.clientQueryData))) {
            return ret;
        }
        if (this.__validFields.get(6)) {
            boolean bl = ret = this.shardId == peer.shardId;
            if (!ret) {
                return ret;
            }
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        RemoteQueryInfo other = new RemoteQueryInfo();
        other.__validFields.or(this.__validFields);
        other.commonInfo = (QueryCommon)this.commonInfo.clone();
        if (this.__validFields.get(2)) {
            other.queryClassType = (TextBytes)this.queryClassType.clone();
        }
        if (this.__validFields.get(3)) {
            other.queryDataClassType = (TextBytes)this.queryDataClassType.clone();
        }
        if (this.__validFields.get(4)) {
            other.queryDataBuffer = (FlexBuffer)this.queryDataBuffer.clone();
        }
        other.clientQueryData = (ClientQueryInfo)this.clientQueryData.clone();
        if (this.__validFields.get(6)) {
            other.shardId = this.shardId;
        }
        return other;
    }

    @Override
    public final void merge(RemoteQueryInfo peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        this.commonInfo.merge(peer.commonInfo);
        if (peer.__validFields.get(2)) {
            this.queryClassType = (TextBytes)peer.queryClassType.clone();
        }
        if (peer.__validFields.get(3)) {
            this.queryDataClassType = (TextBytes)peer.queryDataClassType.clone();
        }
        if (peer.__validFields.get(4)) {
            this.queryDataBuffer = (FlexBuffer)peer.queryDataBuffer.clone();
        }
        this.clientQueryData.merge(peer.clientQueryData);
        if (peer.__validFields.get(6)) {
            this.shardId = peer.shardId;
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashInt(this.commonInfo.hashCode(), result);
        result = MurmurHash.hash(this.queryClassType.getBytes(), this.queryClassType.getOffset(), this.queryClassType.getLength(), result);
        result = MurmurHash.hash(this.queryDataClassType.getBytes(), this.queryDataClassType.getOffset(), this.queryDataClassType.getLength(), result);
        result = MurmurHash.hash(this.queryDataBuffer.get(), this.queryDataBuffer.getOffset(), this.queryDataBuffer.getCount(), result);
        result = MurmurHash.hashInt(this.clientQueryData.hashCode(), result);
        result = MurmurHash.hashInt(this.shardId, result);
        return result;
    }
}

