/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.async.Timer;
import org.commoncrawl.query.BaseConfig;
import org.commoncrawl.query.QueryController;
import org.commoncrawl.query.QueryServerSlave;
import org.commoncrawl.query.SlaveStatus;
import org.commoncrawl.rpc.EmptyStruct;
import org.commoncrawl.rpc.MessageData;
import org.commoncrawl.rpc.OutgoingMessageContext;
import org.commoncrawl.rpc.RPCChannel;
import org.commoncrawl.util.shared.CCStringUtils;

public class QuerySlaveConnection
implements RPCChannel.ConnectionCallback {
    private static final int HEARTBEAT_TIMER_INTERVAL = 50;
    private static final Log LOG = LogFactory.getLog(QuerySlaveConnection.class);
    private String _hostName;
    private int _hostRPCPort;
    private InetSocketAddress _hostAddress;
    private long _lastUpdateTime = -1L;
    private QueryController _controller;
    private Timer _heartbeatTimer = null;
    private boolean _ignoreHeartbeats = false;
    private boolean _online = false;
    private RPCChannel _channel;
    private QueryServerSlave.AsyncStub _slaveService;

    public QuerySlaveConnection(QueryController master, String hostName, int rpcPort) {
        this._controller = master;
        this._hostName = hostName;
        this._hostRPCPort = rpcPort;
        InetAddress slaveAddress = null;
        try {
            LOG.info((Object)("Resolving Slave Address for Slave:" + hostName));
            slaveAddress = InetAddress.getByName(hostName);
            LOG.info((Object)("Resolving Slave Address for Slave:" + hostName + " to:" + slaveAddress.getHostAddress()));
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Unable to Resolve Slave HostName:" + hostName + " Exception:" + CCStringUtils.stringifyException((Throwable)e)));
            throw new RuntimeException("Unable to Resolve Slave HostName:" + hostName + " Exception:" + CCStringUtils.stringifyException((Throwable)e));
        }
        this._hostAddress = new InetSocketAddress(slaveAddress.getHostAddress(), rpcPort);
        if (this._hostAddress == null) {
            throw new RuntimeException("Invalid HostName String in Query Slave Registration: " + this._hostName);
        }
        LOG.info((Object)("Host Address for Slave:" + hostName + " is:" + this._hostAddress));
    }

    public void connect() throws IOException {
        LOG.info((Object)("Opening Channel to Host:" + this.getFullyQualifiedName()));
        this._channel = new RPCChannel(this._controller.getHost().getEventLoop(), null, this._controller.getHost().getOutgoingInterface(), this._hostAddress, this);
        this._channel.open();
        this._slaveService = new QueryServerSlave.AsyncStub(this._channel, null);
    }

    public void shutdown() {
        this.killHeartbeatTimer();
        if (this._channel != null) {
            try {
                this._channel.close();
            }
            catch (IOException e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            }
        }
    }

    public String getHostName() {
        return this._hostName;
    }

    public int getPort() {
        return this._hostRPCPort;
    }

    public String getFullyQualifiedName() {
        return this.getHostName() + ":" + this.getPort();
    }

    public long getLastUpdateTime() {
        return this._lastUpdateTime;
    }

    public boolean isOnline() {
        return this._online;
    }

    public QueryServerSlave.AsyncStub getRemoteStub() {
        return this._slaveService;
    }

    void enableHeartbeats() {
        this._ignoreHeartbeats = false;
    }

    void disableHeartbeats() {
        this._ignoreHeartbeats = true;
    }

    boolean areHeartbeatsDisabled() {
        return this._ignoreHeartbeats;
    }

    @Override
    public void OutgoingChannelConnected(RPCChannel channel) {
        LOG.info((Object)("Connected to Query Slave:" + this.getFullyQualifiedName()));
        this.slaveOnline();
    }

    @Override
    public boolean OutgoingChannelDisconnected(RPCChannel channel) {
        LOG.info((Object)("Disconnect detected for Slave : " + this.getFullyQualifiedName()));
        this.slaveOffline();
        return false;
    }

    private void slaveOnline() {
        try {
            this._slaveService.initializeQuerySlave(this._controller.getBaseConfigForSlave(this.getFullyQualifiedName()), new OutgoingMessageContext.Callback<BaseConfig, SlaveStatus>(){

                @Override
                public void requestComplete(OutgoingMessageContext<BaseConfig, SlaveStatus> request) {
                    if (request.getStatus() != MessageData.Status.Success) {
                        LOG.error((Object)("resetState failed on Slave:" + QuerySlaveConnection.this.getFullyQualifiedName()));
                        QuerySlaveConnection.this.slaveOffline();
                    } else {
                        QuerySlaveConnection.this._online = true;
                        QuerySlaveConnection.this.updateSlaveStatus((SlaveStatus)request.getOutput());
                        QuerySlaveConnection.this.startHeartbeatTimer();
                    }
                }
            });
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            this.slaveOffline();
        }
    }

    private void slaveOffline() {
        this._online = false;
        this.killHeartbeatTimer();
        this._controller.slaveStatusChanged(this.getFullyQualifiedName(), null);
        if (this._channel != null) {
            try {
                this._channel.reconnect();
            }
            catch (IOException e) {
                LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            }
        }
    }

    private void updateSlaveStatus(SlaveStatus status) {
        this._lastUpdateTime = System.currentTimeMillis();
        this._controller.slaveStatusChanged(this.getFullyQualifiedName(), status);
    }

    private void startHeartbeatTimer() {
        this._heartbeatTimer = new Timer(50L, false, new Timer.Callback(){

            @Override
            public void timerFired(final Timer timer) {
                try {
                    QuerySlaveConnection.this._slaveService.heartbeatQuerySlave(new OutgoingMessageContext.Callback<EmptyStruct, SlaveStatus>(){

                        @Override
                        public void requestComplete(OutgoingMessageContext<EmptyStruct, SlaveStatus> request) {
                            boolean forceDisconnect = false;
                            if (request.getStatus() == MessageData.Status.Success) {
                                if (!QuerySlaveConnection.this.areHeartbeatsDisabled()) {
                                    if (((SlaveStatus)request.getOutput()).getQueryStatus().size() != 0) {
                                        // empty if block
                                    }
                                    QuerySlaveConnection.this.updateSlaveStatus((SlaveStatus)request.getOutput());
                                }
                                QuerySlaveConnection.this._controller.getHost().getEventLoop().setTimer(timer);
                            } else {
                                forceDisconnect = true;
                            }
                            if (forceDisconnect) {
                                QuerySlaveConnection.this.slaveOffline();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    QuerySlaveConnection.this.slaveOffline();
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                }
            }
        });
        this._controller.getHost().getEventLoop().setTimer(this._heartbeatTimer);
    }

    private void killHeartbeatTimer() {
        if (this._heartbeatTimer != null) {
            this._controller.getHost().getEventLoop().cancelTimer(this._heartbeatTimer);
            this._heartbeatTimer = null;
        }
    }
}

