/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.query;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;

public class QueryInputSplit
extends RPCStruct<QueryInputSplit>
implements WritableComparable {
    public static final int Field_SHARDID = 1;
    static final int FieldID_MAX = 1;
    private BitSet __validFields = new BitSet(2);
    private int shardId;

    public static QueryInputSplit newInstance(Configuration conf) {
        return (QueryInputSplit)ReflectionUtils.newInstance(QueryInputSplit.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public int compareTo(Object other) {
        int result = Integer.valueOf(this.shardId).compareTo(((QueryInputSplit)other).shardId);
        return result;
    }

    @Override
    public String getKey() {
        return Integer.valueOf(this.shardId).toString();
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final QueryInputSplit setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final QueryInputSplit setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public int getShardId() {
        return this.shardId;
    }

    public QueryInputSplit setShardId(int shardId) {
        this.__validFields.set(1);
        this.shardId = shardId;
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "shardId", 1);
            encoder.writeInt(output, this.shardId);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.shardId = decoder.readInt(input);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.shardId = 0;
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof QueryInputSplit)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        QueryInputSplit peer = (QueryInputSplit)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.shardId == peer.shardId;
            if (!ret) {
                return ret;
            }
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        QueryInputSplit other = new QueryInputSplit();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.shardId = this.shardId;
        }
        return other;
    }

    @Override
    public final void merge(QueryInputSplit peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.shardId = peer.shardId;
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashInt(this.shardId, result);
        return result;
    }
}

