/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.protocol.shared;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class ArcFileHeaderItem
extends RPCStruct<ArcFileHeaderItem>
implements Writable {
    public static final int Field_ITEMKEY = 1;
    public static final int Field_ITEMVALUE = 2;
    static final int FieldID_MAX = 2;
    private BitSet __validFields = new BitSet(3);
    private TextBytes itemKey = new TextBytes();
    private TextBytes itemValue = new TextBytes();

    public static ArcFileHeaderItem newInstance(Configuration conf) {
        return (ArcFileHeaderItem)ReflectionUtils.newInstance(ArcFileHeaderItem.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final ArcFileHeaderItem setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final ArcFileHeaderItem setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public TextBytes getItemKeyAsTextBytes() {
        return this.itemKey;
    }

    public String getItemKey() {
        return this.itemKey.toString();
    }

    public ArcFileHeaderItem setItemKey(String itemKey) {
        this.__validFields.set(1);
        this.itemKey.set(itemKey);
        return this;
    }

    public TextBytes getItemValueAsTextBytes() {
        return this.itemValue;
    }

    public String getItemValue() {
        return this.itemValue.toString();
    }

    public ArcFileHeaderItem setItemValue(String itemValue) {
        this.__validFields.set(2);
        this.itemValue.set(itemValue);
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "itemKey", 1);
            encoder.writeTextBytes(output, this.itemKey);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "itemValue", 2);
            encoder.writeTextBytes(output, this.itemValue);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    decoder.readTextBytes(input, this.itemKey);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    decoder.readTextBytes(input, this.itemValue);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.itemKey.clear();
        this.itemValue.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof ArcFileHeaderItem)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        ArcFileHeaderItem peer = (ArcFileHeaderItem)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1) && !(ret = this.itemKey.equals(peer.itemKey))) {
            return ret;
        }
        if (this.__validFields.get(2) && !(ret = this.itemValue.equals(peer.itemValue))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        ArcFileHeaderItem other = new ArcFileHeaderItem();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.itemKey = (TextBytes)this.itemKey.clone();
        }
        if (this.__validFields.get(2)) {
            other.itemValue = (TextBytes)this.itemValue.clone();
        }
        return other;
    }

    @Override
    public final void merge(ArcFileHeaderItem peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.itemKey = (TextBytes)peer.itemKey.clone();
        }
        if (peer.__validFields.get(2)) {
            this.itemValue = (TextBytes)peer.itemValue.clone();
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hash(this.itemKey.getBytes(), this.itemKey.getOffset(), this.itemKey.getLength(), result);
        result = MurmurHash.hash(this.itemValue.getBytes(), this.itemValue.getOffset(), this.itemValue.getLength(), result);
        return result;
    }
}

