/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.util.ReflectionUtils;
import org.commoncrawl.rpc.BinaryProtocol;
import org.commoncrawl.rpc.RPCStruct;
import org.commoncrawl.util.shared.FlexBuffer;
import org.commoncrawl.util.shared.ImmutableBuffer;
import org.commoncrawl.util.shared.MurmurHash;
import org.commoncrawl.util.shared.TextBytes;

public class ArchiveInfo
extends RPCStruct<ArchiveInfo>
implements Writable {
    public static final int Field_ARCFILEDATE = 1;
    public static final int Field_ARCFILEINDEX = 2;
    public static final int Field_ARCFILEOFFSET = 3;
    public static final int Field_COMPRESSEDSIZE = 4;
    public static final int Field_CRAWLNUMBER = 5;
    public static final int Field_DOCUMENTVERSION = 6;
    public static final int Field_PARSESEGMENTID = 7;
    public static final int Field_SIGNATURE = 8;
    public static final int Field_SIMHASH = 9;
    public static final int Field_CACHEITEMSRC = 10;
    static final int FieldID_MAX = 10;
    private BitSet __validFields = new BitSet(11);
    private long arcfileDate;
    private int arcfileIndex;
    private int arcfileOffset;
    private int compressedSize;
    private int crawlNumber;
    private int documentVersion;
    private int parseSegmentId;
    private FlexBuffer signature = new FlexBuffer();
    private long simhash;
    private TextBytes cacheItemSrc = new TextBytes();

    public static ArchiveInfo newInstance(Configuration conf) {
        return (ArchiveInfo)ReflectionUtils.newInstance(ArchiveInfo.class, (Configuration)conf);
    }

    public void write(DataOutput out) throws IOException {
        this.serialize(out, new BinaryProtocol());
    }

    public void readFields(DataInput in) throws IOException {
        this.deserialize(in, new BinaryProtocol());
    }

    public final boolean isFieldDirty(int fieldId) {
        return this.__validFields.get(fieldId);
    }

    public final ArchiveInfo setFieldDirty(int fieldId) {
        this.__validFields.set(fieldId);
        return this;
    }

    public final ArchiveInfo setFieldClean(int fieldId) {
        this.__validFields.clear(fieldId);
        return this;
    }

    public long getArcfileDate() {
        return this.arcfileDate;
    }

    public ArchiveInfo setArcfileDate(long arcfileDate) {
        this.__validFields.set(1);
        this.arcfileDate = arcfileDate;
        return this;
    }

    public int getArcfileIndex() {
        return this.arcfileIndex;
    }

    public ArchiveInfo setArcfileIndex(int arcfileIndex) {
        this.__validFields.set(2);
        this.arcfileIndex = arcfileIndex;
        return this;
    }

    public int getArcfileOffset() {
        return this.arcfileOffset;
    }

    public ArchiveInfo setArcfileOffset(int arcfileOffset) {
        this.__validFields.set(3);
        this.arcfileOffset = arcfileOffset;
        return this;
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    public ArchiveInfo setCompressedSize(int compressedSize) {
        this.__validFields.set(4);
        this.compressedSize = compressedSize;
        return this;
    }

    public int getCrawlNumber() {
        return this.crawlNumber;
    }

    public ArchiveInfo setCrawlNumber(int crawlNumber) {
        this.__validFields.set(5);
        this.crawlNumber = crawlNumber;
        return this;
    }

    public int getDocumentVersion() {
        return this.documentVersion;
    }

    public ArchiveInfo setDocumentVersion(int documentVersion) {
        this.__validFields.set(6);
        this.documentVersion = documentVersion;
        return this;
    }

    public int getParseSegmentId() {
        return this.parseSegmentId;
    }

    public ArchiveInfo setParseSegmentId(int parseSegmentId) {
        this.__validFields.set(7);
        this.parseSegmentId = parseSegmentId;
        return this;
    }

    public ImmutableBuffer getSignature() {
        return new ImmutableBuffer(this.signature);
    }

    public ArchiveInfo setSignature(FlexBuffer signature) {
        this.__validFields.set(8);
        this.signature = signature;
        return this;
    }

    public ArchiveInfo setSignature(Buffer signature, boolean shared) {
        this.__validFields.set(8);
        this.signature = new FlexBuffer(signature.get(), 0, signature.getCount(), shared);
        return this;
    }

    public long getSimhash() {
        return this.simhash;
    }

    public ArchiveInfo setSimhash(long simhash) {
        this.__validFields.set(9);
        this.simhash = simhash;
        return this;
    }

    public TextBytes getCacheItemSrcAsTextBytes() {
        return this.cacheItemSrc;
    }

    public String getCacheItemSrc() {
        return this.cacheItemSrc.toString();
    }

    public ArchiveInfo setCacheItemSrc(String cacheItemSrc) {
        this.__validFields.set(10);
        this.cacheItemSrc.set(cacheItemSrc);
        return this;
    }

    public final boolean isObjectDirty() {
        boolean isDirty = !this.__validFields.isEmpty();
        return isDirty;
    }

    @Override
    public final void serialize(DataOutput output, BinaryProtocol encoder) throws IOException {
        encoder.beginFields(output);
        if (this.__validFields.get(1)) {
            encoder.beginField(output, "arcfileDate", 1);
            encoder.writeVLong(output, this.arcfileDate);
        }
        if (this.__validFields.get(2)) {
            encoder.beginField(output, "arcfileIndex", 2);
            encoder.writeVInt(output, this.arcfileIndex);
        }
        if (this.__validFields.get(3)) {
            encoder.beginField(output, "arcfileOffset", 3);
            encoder.writeVInt(output, this.arcfileOffset);
        }
        if (this.__validFields.get(4)) {
            encoder.beginField(output, "compressedSize", 4);
            encoder.writeVInt(output, this.compressedSize);
        }
        if (this.__validFields.get(5)) {
            encoder.beginField(output, "crawlNumber", 5);
            encoder.writeVInt(output, this.crawlNumber);
        }
        if (this.__validFields.get(6)) {
            encoder.beginField(output, "documentVersion", 6);
            encoder.writeVInt(output, this.documentVersion);
        }
        if (this.__validFields.get(7)) {
            encoder.beginField(output, "parseSegmentId", 7);
            encoder.writeVInt(output, this.parseSegmentId);
        }
        if (this.__validFields.get(8)) {
            encoder.beginField(output, "signature", 8);
            encoder.writeFlexBuffer(output, this.signature);
        }
        if (this.__validFields.get(9)) {
            encoder.beginField(output, "simhash", 9);
            encoder.writeVLong(output, this.simhash);
        }
        if (this.__validFields.get(10)) {
            encoder.beginField(output, "cacheItemSrc", 10);
            encoder.writeTextBytes(output, this.cacheItemSrc);
        }
        encoder.endFields(output);
    }

    @Override
    public final void deserialize(DataInput input, BinaryProtocol decoder) throws IOException {
        int fieldId;
        this.clear();
        decoder.pushFieldIdEncodingMode(0);
        while ((fieldId = decoder.readFieldId(input)) != -1) {
            switch (fieldId) {
                case 1: {
                    this.__validFields.set(1);
                    this.arcfileDate = decoder.readVLong(input);
                    break;
                }
                case 2: {
                    this.__validFields.set(2);
                    this.arcfileIndex = decoder.readVInt(input);
                    break;
                }
                case 3: {
                    this.__validFields.set(3);
                    this.arcfileOffset = decoder.readVInt(input);
                    break;
                }
                case 4: {
                    this.__validFields.set(4);
                    this.compressedSize = decoder.readVInt(input);
                    break;
                }
                case 5: {
                    this.__validFields.set(5);
                    this.crawlNumber = decoder.readVInt(input);
                    break;
                }
                case 6: {
                    this.__validFields.set(6);
                    this.documentVersion = decoder.readVInt(input);
                    break;
                }
                case 7: {
                    this.__validFields.set(7);
                    this.parseSegmentId = decoder.readVInt(input);
                    break;
                }
                case 8: {
                    this.__validFields.set(8);
                    decoder.readFlexBuffer(input, this.signature);
                    break;
                }
                case 9: {
                    this.__validFields.set(9);
                    this.simhash = decoder.readVLong(input);
                    break;
                }
                case 10: {
                    this.__validFields.set(10);
                    decoder.readTextBytes(input, this.cacheItemSrc);
                }
            }
        }
        decoder.popFieldIdEncodingMode();
    }

    public final void clear() {
        this.__validFields.clear();
        this.arcfileDate = 0L;
        this.arcfileIndex = 0;
        this.arcfileOffset = 0;
        this.compressedSize = 0;
        this.crawlNumber = 0;
        this.documentVersion = 0;
        this.parseSegmentId = 0;
        this.signature.reset();
        this.simhash = 0L;
        this.cacheItemSrc.clear();
    }

    @Override
    public final boolean equals(Object peer_) {
        if (!(peer_ instanceof ArchiveInfo)) {
            return false;
        }
        if (peer_ == this) {
            return true;
        }
        ArchiveInfo peer = (ArchiveInfo)peer_;
        boolean ret = this.__validFields.equals(peer.__validFields);
        if (!ret) {
            return ret;
        }
        if (this.__validFields.get(1)) {
            boolean bl = ret = this.arcfileDate == peer.arcfileDate;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(2)) {
            boolean bl = ret = this.arcfileIndex == peer.arcfileIndex;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(3)) {
            boolean bl = ret = this.arcfileOffset == peer.arcfileOffset;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(4)) {
            boolean bl = ret = this.compressedSize == peer.compressedSize;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(5)) {
            boolean bl = ret = this.crawlNumber == peer.crawlNumber;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(6)) {
            boolean bl = ret = this.documentVersion == peer.documentVersion;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(7)) {
            boolean bl = ret = this.parseSegmentId == peer.parseSegmentId;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(8) && !(ret = this.signature.equals(peer.signature))) {
            return ret;
        }
        if (this.__validFields.get(9)) {
            boolean bl = ret = this.simhash == peer.simhash;
            if (!ret) {
                return ret;
            }
        }
        if (this.__validFields.get(10) && !(ret = this.cacheItemSrc.equals(peer.cacheItemSrc))) {
            return ret;
        }
        return ret;
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        ArchiveInfo other = new ArchiveInfo();
        other.__validFields.or(this.__validFields);
        if (this.__validFields.get(1)) {
            other.arcfileDate = this.arcfileDate;
        }
        if (this.__validFields.get(2)) {
            other.arcfileIndex = this.arcfileIndex;
        }
        if (this.__validFields.get(3)) {
            other.arcfileOffset = this.arcfileOffset;
        }
        if (this.__validFields.get(4)) {
            other.compressedSize = this.compressedSize;
        }
        if (this.__validFields.get(5)) {
            other.crawlNumber = this.crawlNumber;
        }
        if (this.__validFields.get(6)) {
            other.documentVersion = this.documentVersion;
        }
        if (this.__validFields.get(7)) {
            other.parseSegmentId = this.parseSegmentId;
        }
        if (this.__validFields.get(8)) {
            other.signature = (FlexBuffer)this.signature.clone();
        }
        if (this.__validFields.get(9)) {
            other.simhash = this.simhash;
        }
        if (this.__validFields.get(10)) {
            other.cacheItemSrc = (TextBytes)this.cacheItemSrc.clone();
        }
        return other;
    }

    @Override
    public final void merge(ArchiveInfo peer) throws CloneNotSupportedException {
        this.__validFields.or(peer.__validFields);
        if (peer.__validFields.get(1)) {
            this.arcfileDate = peer.arcfileDate;
        }
        if (peer.__validFields.get(2)) {
            this.arcfileIndex = peer.arcfileIndex;
        }
        if (peer.__validFields.get(3)) {
            this.arcfileOffset = peer.arcfileOffset;
        }
        if (peer.__validFields.get(4)) {
            this.compressedSize = peer.compressedSize;
        }
        if (peer.__validFields.get(5)) {
            this.crawlNumber = peer.crawlNumber;
        }
        if (peer.__validFields.get(6)) {
            this.documentVersion = peer.documentVersion;
        }
        if (peer.__validFields.get(7)) {
            this.parseSegmentId = peer.parseSegmentId;
        }
        if (peer.__validFields.get(8)) {
            this.signature = (FlexBuffer)peer.signature.clone();
        }
        if (peer.__validFields.get(9)) {
            this.simhash = peer.simhash;
        }
        if (peer.__validFields.get(10)) {
            this.cacheItemSrc = (TextBytes)peer.cacheItemSrc.clone();
        }
    }

    @Override
    public final int hashCode() {
        int result = 1;
        result = MurmurHash.hashLong(this.arcfileDate, result);
        result = MurmurHash.hashInt(this.arcfileIndex, result);
        result = MurmurHash.hashInt(this.arcfileOffset, result);
        result = MurmurHash.hashInt(this.compressedSize, result);
        result = MurmurHash.hashInt(this.crawlNumber, result);
        result = MurmurHash.hashInt(this.documentVersion, result);
        result = MurmurHash.hashInt(this.parseSegmentId, result);
        result = MurmurHash.hash(this.signature.get(), this.signature.getOffset(), this.signature.getCount(), result);
        result = MurmurHash.hashLong(this.simhash, result);
        result = MurmurHash.hash(this.cacheItemSrc.getBytes(), this.cacheItemSrc.getOffset(), this.cacheItemSrc.getLength(), result);
        return result;
    }
}

