/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.io.internal.NIOClientTCPSocket;
import org.commoncrawl.io.internal.NIOServerSocket;
import org.commoncrawl.io.internal.NIOServerSocketListener;
import org.commoncrawl.io.internal.NIOSocket;
import org.commoncrawl.io.internal.NIOSocketListener;

public class NIOServerTCPSocket
implements NIOServerSocket {
    int _socketId = NIOSocket._idFactory.getNextId();
    ServerSocketChannel _channel;
    NIOServerSocketListener _listener;
    public static final Log LOG = LogFactory.getLog(NIOServerTCPSocket.class);

    public NIOServerTCPSocket(NIOServerSocketListener listener) {
        this._listener = listener;
    }

    @Override
    public int getSocketId() {
        return this._socketId;
    }

    @Override
    public void open(InetSocketAddress address) throws IOException {
        if (this._channel != null) {
            throw new IOException("Invalid State. Socket already bound");
        }
        LOG.info((Object)(this + " Binding to: " + address.getAddress().getHostAddress() + ":" + address.getPort()));
        this._channel = ServerSocketChannel.open();
        NIOServerTCPSocket.setListenerSocketOptions(this._channel);
        this._channel.socket().bind(address);
    }

    private static void setListenerSocketOptions(ServerSocketChannel channel) throws IOException {
        channel.socket().setReuseAddress(true);
        channel.configureBlocking(false);
    }

    private static void setClientSocketOptions(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
        channel.configureBlocking(false);
    }

    @Override
    public void close() {
        try {
            if (this._channel != null) {
                if (this._channel.socket() != null) {
                    this._channel.socket().close();
                }
                this._channel.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this._channel = null;
        }
    }

    @Override
    public AbstractSelectableChannel getChannel() {
        return this._channel;
    }

    @Override
    public NIOSocketListener getListener() {
        return this._listener;
    }

    @Override
    public boolean isOpen() {
        return this._channel != null;
    }

    @Override
    public void acceptable() {
        if (this._listener != null) {
            SocketChannel newClientChannel = null;
            try {
                newClientChannel = this._channel.accept();
                NIOServerTCPSocket.setClientSocketOptions(newClientChannel);
                NIOClientTCPSocket newSocketObj = new NIOClientTCPSocket(newClientChannel);
                this._listener.Accepted(newSocketObj);
            }
            catch (IOException e) {
                if (newClientChannel != null) {
                    try {
                        newClientChannel.close();
                    }
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setListener(NIOSocketListener listener) {
        this._listener = (NIOServerSocketListener)listener;
    }

    @Override
    public boolean readsDisabled() {
        return false;
    }
}

