/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.io.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.commoncrawl.io.internal.NIOBufferList;

public class NIOBufferListInputStream
extends InputStream {
    protected NIOBufferList _bufferQueue = null;
    protected ByteBuffer _activeBuf = null;
    protected long _streamPos = 0L;

    public NIOBufferListInputStream(NIOBufferList source) {
        this._bufferQueue = source;
    }

    @Override
    public synchronized void reset() {
        this._activeBuf = null;
    }

    public long getStreamPos() {
        return this._streamPos;
    }

    protected synchronized void getNext() throws IOException {
        this._activeBuf = null;
        this._activeBuf = this._bufferQueue.read();
    }

    protected synchronized void ensureBuffer() throws IOException {
        if (this._activeBuf == null || this._activeBuf.remaining() == 0) {
            this.getNext();
        }
    }

    @Override
    public synchronized int read() throws IOException {
        this.ensureBuffer();
        if (this._activeBuf != null) {
            ++this._streamPos;
            return this._activeBuf.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int available() throws IOException {
        int available = 0;
        if (this._activeBuf != null) {
            available += this._activeBuf.remaining();
        }
        return available += this._bufferQueue.available();
    }

    public synchronized NIOBufferListInputStream subStream(int desiredStreamSize) throws IOException {
        if (this.available() < desiredStreamSize) {
            throw new EOFException();
        }
        NIOBufferList bufferList = new NIOBufferList();
        int sizeOut = 0;
        int len = desiredStreamSize;
        while (len != 0) {
            ByteBuffer buffer;
            int sizeToRead;
            this.ensureBuffer();
            if (this._activeBuf == null) break;
            int sizeAvailable = this._activeBuf.remaining();
            if (sizeAvailable <= (sizeToRead = Math.min(sizeAvailable, len))) {
                buffer = this._activeBuf.slice();
                buffer.position(buffer.limit());
                bufferList.write(buffer);
                this._activeBuf = null;
            } else {
                buffer = this._activeBuf.slice();
                buffer.limit(buffer.position() + sizeToRead);
                buffer.position(buffer.limit());
                bufferList.write(buffer);
                this._activeBuf.position(this._activeBuf.position() + sizeToRead);
            }
            len -= sizeToRead;
            sizeOut += sizeToRead;
        }
        bufferList.flush();
        if (sizeOut != desiredStreamSize) {
            throw new EOFException();
        }
        this._streamPos += (long)sizeOut;
        return new NIOBufferListInputStream(bufferList);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int sizeOut = 0;
        while (len != 0) {
            this.ensureBuffer();
            if (this._activeBuf == null) break;
            int sizeAvailable = this._activeBuf.remaining();
            int sizeToRead = Math.min(sizeAvailable, len);
            this._activeBuf.get(b, off, sizeToRead);
            len -= sizeToRead;
            sizeOut += sizeToRead;
            off += sizeToRead;
        }
        this._streamPos += (long)sizeOut;
        return sizeOut != 0 ? sizeOut : -1;
    }

    @Override
    public synchronized int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long skipAmount) throws IOException {
        long skipAmountOut = 0L;
        while (skipAmount != 0L) {
            this.ensureBuffer();
            if (this._activeBuf == null) break;
            long sizeAvailable = this._activeBuf.remaining();
            int sizeToSkip = (int)Math.min(sizeAvailable, skipAmount);
            this._activeBuf.position(this._activeBuf.position() + sizeToSkip);
            skipAmount -= (long)sizeToSkip;
            skipAmountOut += (long)sizeToSkip;
        }
        this._streamPos += skipAmountOut;
        return skipAmountOut;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this._activeBuf != null && this._activeBuf.remaining() != 0 && this._bufferQueue != null) {
            this._bufferQueue.putBack(this._activeBuf);
        }
        super.close();
    }
}

