/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.mergeutils;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.commoncrawl.hadoop.mergeutils.MergeSortSpillWriter;
import org.commoncrawl.hadoop.mergeutils.OptimizedKeyGeneratorAndComparator;
import org.commoncrawl.hadoop.mergeutils.RawDataSpillWriter;
import org.commoncrawl.hadoop.mergeutils.RawKeyValueComparator;
import org.commoncrawl.util.shared.CCStringUtils;

public class MergeSortSpillWriterUnitTest {
    public static final Log LOG = LogFactory.getLog(MergeSortSpillWriterUnitTest.class);

    public static void main(String[] args) {
        try {
            new BasicTest().runTest();
            new BasicOptimizedTest().runTest();
            new BasicOptimizedWithLongAndBufferTest().runTest();
            new BasicOptimizedWithBufferOnlyTest(1000000, 10000, 2000000, 1000000).runTest();
            new BasicOptimizedWithBufferOnlyTest(1000000, 1000000, 200000000, 1000000).runTest();
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
        }
    }

    public static class BasicOptimizedWithBufferOnlyTest
    extends BaseTest {
        public BasicOptimizedWithBufferOnlyTest(int keySetSize, int indexBufferSize, int dataBufferSize, int spillBufferSize) {
            super("OptimizedKeyGenerator - using Buffer ONLY Keys Test", keySetSize, indexBufferSize, dataBufferSize, spillBufferSize);
        }

        @Override
        protected MergeSortSpillWriter<IntWritable, Text> constructMerger(Configuration conf, RawDataSpillWriter<IntWritable, Text> writer, FileSystem tempFileSystem, Path tempFilePath, RawKeyValueComparator<IntWritable, Text> comparator, Class keyClass, Class valueClass) throws IOException {
            return new MergeSortSpillWriter<IntWritable, Text>(conf, writer, tempFileSystem, tempFilePath, new OptimizedKeyGeneratorAndComparator<IntWritable, Text>(){
                DataInputBuffer key1ReaderStream = new DataInputBuffer();
                DataInputBuffer key2ReaderStream = new DataInputBuffer();

                @Override
                public void generateOptimizedKeyForPair(IntWritable key, Text value, OptimizedKeyGeneratorAndComparator.OptimizedKey optimizedKeyOut) throws IOException {
                    DataOutputStream bufferOutput = optimizedKeyOut.getBufferKeyValueStream();
                    bufferOutput.writeLong(key.get());
                    bufferOutput.close();
                }

                @Override
                public int getGeneratedKeyType() {
                    return 2;
                }

                @Override
                public int compareOptimizedBufferKeys(byte[] key1Data, int key1Offset, int key1Length, byte[] key2Data, int key2Offset, int key2Length) throws IOException {
                    this.key1ReaderStream.reset(key1Data, key1Offset, key1Length);
                    this.key2ReaderStream.reset(key2Data, key2Offset, key2Length);
                    return (int)(this.key1ReaderStream.readLong() - this.key2ReaderStream.readLong());
                }
            }, keyClass, valueClass, null, null);
        }
    }

    public static class BasicOptimizedWithLongAndBufferTest
    extends BaseTest {
        public BasicOptimizedWithLongAndBufferTest() {
            super("OptimizedKeyGenerator - using Long AND Buffer Keys Test", 1000000, 10000, 2000000, 1000000);
        }

        @Override
        protected MergeSortSpillWriter<IntWritable, Text> constructMerger(Configuration conf, RawDataSpillWriter<IntWritable, Text> writer, FileSystem tempFileSystem, Path tempFilePath, RawKeyValueComparator<IntWritable, Text> comparator, Class keyClass, Class valueClass) throws IOException {
            return new MergeSortSpillWriter<IntWritable, Text>(conf, writer, tempFileSystem, tempFilePath, new OptimizedKeyGeneratorAndComparator<IntWritable, Text>(){
                DataInputBuffer key1ReaderStream = new DataInputBuffer();
                DataInputBuffer key2ReaderStream = new DataInputBuffer();

                @Override
                public void generateOptimizedKeyForPair(IntWritable key, Text value, OptimizedKeyGeneratorAndComparator.OptimizedKey optimizedKeyOut) throws IOException {
                    optimizedKeyOut.setLongKeyValue(0L);
                    DataOutputStream bufferOutput = optimizedKeyOut.getBufferKeyValueStream();
                    bufferOutput.writeLong(key.get());
                    bufferOutput.close();
                }

                @Override
                public int getGeneratedKeyType() {
                    return 3;
                }

                @Override
                public int compareOptimizedBufferKeys(byte[] key1Data, int key1Offset, int key1Length, byte[] key2Data, int key2Offset, int key2Length) throws IOException {
                    this.key1ReaderStream.reset(key1Data, key1Offset, key1Length);
                    this.key2ReaderStream.reset(key2Data, key2Offset, key2Length);
                    return (int)(this.key1ReaderStream.readLong() - this.key2ReaderStream.readLong());
                }
            }, keyClass, valueClass, null, null);
        }
    }

    public static class BasicOptimizedTest
    extends BaseTest {
        public BasicOptimizedTest() {
            super("OptimizedKeyGenerator - using Long ONLY Keys Test", 1000000, 10000, 2000000, 1000000);
        }

        @Override
        protected MergeSortSpillWriter<IntWritable, Text> constructMerger(Configuration conf, RawDataSpillWriter<IntWritable, Text> writer, FileSystem tempFileSystem, Path tempFilePath, RawKeyValueComparator<IntWritable, Text> comparator, Class keyClass, Class valueClass) throws IOException {
            return new MergeSortSpillWriter<IntWritable, Text>(conf, writer, tempFileSystem, tempFilePath, new OptimizedKeyGeneratorAndComparator<IntWritable, Text>(){

                @Override
                public void generateOptimizedKeyForPair(IntWritable key, Text value, OptimizedKeyGeneratorAndComparator.OptimizedKey optimizedKeyOut) throws IOException {
                    optimizedKeyOut.setLongKeyValue(key.get());
                }

                @Override
                public int getGeneratedKeyType() {
                    return 1;
                }
            }, keyClass, valueClass, null, null);
        }
    }

    public static class BasicTest
    extends BaseTest {
        public BasicTest() {
            super("Basic RawKeyValueComparator Test", 1000000, 10000, 2000000, 1000000);
        }

        @Override
        protected MergeSortSpillWriter<IntWritable, Text> constructMerger(Configuration conf, RawDataSpillWriter<IntWritable, Text> writer, FileSystem tempFileSystem, Path tempFilePath, RawKeyValueComparator<IntWritable, Text> comparator, Class keyClass, Class valueClass) throws IOException {
            return new MergeSortSpillWriter<IntWritable, Text>(conf, writer, tempFileSystem, tempFilePath, null, comparator, keyClass, valueClass, null, null);
        }
    }

    static abstract class BaseTest {
        TreeMap<Integer, Text> originalKeyValueMap = new TreeMap();
        int[] index;
        String _testName = null;
        int _keySetSize = -1;
        int _indexBufferSize = -1;
        int _dataBufferSize = -1;
        int _spillBufferSize = -1;

        public BaseTest(String testName, int keySetSize, int indexBufferSize, int dataBufferSize, int spillBufferSize) {
            this._testName = testName;
            this._keySetSize = keySetSize;
            this._indexBufferSize = indexBufferSize;
            this._dataBufferSize = dataBufferSize;
            this._spillBufferSize = spillBufferSize;
        }

        public void runTest() throws IOException {
            LOG.info((Object)("*************** STARTING TEST:" + this._testName));
            LOG.info((Object)("Set Size:" + this._keySetSize));
            LOG.info((Object)("Index Buffer Size:" + this._indexBufferSize));
            LOG.info((Object)("Data Buffer Size:" + this._dataBufferSize));
            LOG.info((Object)("Spill Buffer Size:" + this._spillBufferSize));
            LOG.info((Object)"");
            long testStartTime = System.currentTimeMillis();
            this.index = new int[this._keySetSize];
            for (int i = 0; i < this._keySetSize; ++i) {
                this.index[i] = i;
                this.originalKeyValueMap.put(i, new Text(BaseTest.keyForNumber(i)));
            }
            Random r = new Random();
            for (int i = this.index.length; i > 1; --i) {
                BaseTest.swap(this.index, i - 1, r.nextInt(i));
            }
            RawDataSpillWriter<IntWritable, Text> validatingSpillWriter = new RawDataSpillWriter<IntWritable, Text>(){
                int closeCount = 0;
                int spilledKeyCount = 0;
                DataInputBuffer keyReader = new DataInputBuffer();
                DataInputBuffer valueReader = new DataInputBuffer();
                IntWritable keyObject = new IntWritable();
                Text valueObject = new Text();

                @Override
                public void close() throws IOException {
                    if (++this.closeCount > 1) {
                        throw new IOException("Close Called One Too Many Times!");
                    }
                    if (this.spilledKeyCount != BaseTest.this.index.length) {
                        throw new IOException("Spilled Key Count:" + this.spilledKeyCount + " Excpected Key Count:" + BaseTest.this.index.length);
                    }
                }

                @Override
                public void spillRecord(IntWritable key, Text value) throws IOException {
                    if (key.get() != this.spilledKeyCount) {
                        throw new IOException("Got Key:" + key.get() + " Expected Key:" + this.spilledKeyCount);
                    }
                    Text expectedValue = BaseTest.this.originalKeyValueMap.get(this.spilledKeyCount);
                    if (expectedValue == null || value == null) {
                        throw new IOException("Null Expected or Incoming Value");
                    }
                    if (expectedValue.compareTo((BinaryComparable)value) != 0) {
                        throw new IOException("Expected Value:" + expectedValue + " @index:" + this.spilledKeyCount + " differs from resulting value:" + value);
                    }
                    ++this.spilledKeyCount;
                }

                @Override
                public void spillRawRecord(byte[] keyData, int keyOffset, int keyLength, byte[] valueData, int valueOffset, int valueLength) throws IOException {
                    this.keyReader.reset(keyData, keyOffset, keyLength);
                    this.valueReader.reset(valueData, valueOffset, valueLength);
                    this.keyObject.readFields((DataInput)this.keyReader);
                    this.valueObject.readFields((DataInput)this.valueReader);
                    this.spillRecord(this.keyObject, this.valueObject);
                }
            };
            Configuration conf = new Configuration();
            RawKeyValueComparator<IntWritable, Text> comparator = new RawKeyValueComparator<IntWritable, Text>(){
                DataInputBuffer keyReader1 = new DataInputBuffer();
                DataInputBuffer keyReader2 = new DataInputBuffer();

                @Override
                public int compareRaw(byte[] key1Data, int key1Offset, int key1Length, byte[] key2Data, int key2Offset, int key2Length, byte[] value1Data, int value1Offset, int value1Length, byte[] value2Data, int value2Offset, int value2Length) throws IOException {
                    this.keyReader1.reset(key1Data, key1Offset, key1Length);
                    this.keyReader2.reset(key2Data, key2Offset, key2Length);
                    return Integer.valueOf(this.keyReader1.readInt()).compareTo(this.keyReader2.readInt());
                }

                @Override
                public int compare(IntWritable key1, Text value1, IntWritable key2, Text value2) {
                    return key1.compareTo((Object)key2);
                }
            };
            conf.setInt("commoncrawl.spill.indexbuffer.size", this._indexBufferSize);
            conf.setInt("commoncrawl.spill.databuffer.size", this._dataBufferSize);
            conf.setInt("commoncrawl.spillwriter.buffer.size", this._spillBufferSize);
            MergeSortSpillWriter<IntWritable, Text> merger = this.constructMerger(conf, validatingSpillWriter, (FileSystem)FileSystem.getLocal((Configuration)conf), new Path("/tmp"), comparator, IntWritable.class, Text.class);
            for (int i = 0; i < this.index.length; ++i) {
                merger.spillRecord(new IntWritable(this.index[i]), (Text)((Writable)this.originalKeyValueMap.get(this.index[i])));
            }
            merger.close();
            validatingSpillWriter.close();
            LOG.info((Object)("*************** ENDING TEST:" + this._testName + " TOOK:" + (System.currentTimeMillis() - testStartTime)));
        }

        protected abstract MergeSortSpillWriter<IntWritable, Text> constructMerger(Configuration var1, RawDataSpillWriter<IntWritable, Text> var2, FileSystem var3, Path var4, RawKeyValueComparator<IntWritable, Text> var5, Class var6, Class var7) throws IOException;

        private static final void swap(int[] arr, int i, int j) {
            int tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
        }

        private static final String keyForNumber(int number) {
            int patternStartIdx = number % 26;
            int patternSize = number % 100 + 1;
            StringBuffer buffer = new StringBuffer(patternSize);
            int currPatternIdx = patternStartIdx;
            for (int i = 0; i < patternSize; ++i) {
                buffer.append((char)(65 + currPatternIdx));
                currPatternIdx = (currPatternIdx + 1) % 26;
            }
            return buffer.toString();
        }
    }
}

