/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.mapreduce;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.commoncrawl.util.shared.ARCFileReader;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.S3InputStream;
import org.jets3t.service.Jets3tProperties;

public class ARCFileRecordReader
extends RecordReader<Text, BytesWritable> {
    private static final Log LOG = LogFactory.getLog(ARCFileRecordReader.class);
    protected Configuration conf;
    ARCFileReader reader;
    private Text key = new Text();
    private BytesWritable value = new BytesWritable();
    private long start;
    private long end;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSplit fileSplit = (FileSplit)split;
        this.conf = context.getConfiguration();
        Path path = fileSplit.getPath();
        FileSystem fs = path.getFileSystem(this.conf);
        Object in = null;
        if (fs instanceof NativeS3FileSystem) {
            if (this.conf.getBoolean("fs.s3n.use.s3inputstream", false)) {
                in = new S3InputStream(path.toUri(), this.conf.get("fs.s3n.awsAccessKeyId"), this.conf.get("fs.s3n.awsSecretAccessKey"), 0x100000);
            } else {
                Jets3tProperties properties = Jets3tProperties.getInstance((String)"jets3t.properties");
                properties.setProperty("s3service.https-only", "false");
            }
        }
        if (in == null) {
            in = fs.open(path);
        }
        try {
            this.reader = new ARCFileReader((InputStream)in);
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            in.close();
            throw e;
        }
        this.start = fileSplit.getStart();
        this.end = fileSplit.getLength();
        if (this.start != 0L || fs.getFileStatus(path).getLen() != this.end) {
            throw new IOException("Invalid FileSplit encountered! Split Details:" + split.toString());
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.reader.hasMoreItems()) {
            this.reader.nextKeyValue(this.key, this.value);
            return true;
        }
        return false;
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.key;
    }

    public BytesWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value;
    }

    public float getProgress() throws IOException, InterruptedException {
        return Math.min(1.0f, (float)(this.reader.getPosition() - this.start) / (float)(this.end - this.start));
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

