/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.commoncrawl.hadoop.io.mapreduce.ARCFileRecordReader;
import org.commoncrawl.protocol.shared.ArcFileItem;
import org.commoncrawl.util.shared.ArcFileItemUtils;

public class ARCFileItemInputFormat
extends FileInputFormat<Text, ArcFileItem> {
    public RecordReader<Text, ArcFileItem> createRecordReader(final InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        final ARCFileRecordReader reader = new ARCFileRecordReader();
        reader.initialize(split, context);
        return new RecordReader<Text, ArcFileItem>(){
            final ArcFileItem currentValue = new ArcFileItem();

            public void close() throws IOException {
                reader.close();
            }

            public Text getCurrentKey() throws IOException, InterruptedException {
                return reader.getCurrentKey();
            }

            public ArcFileItem getCurrentValue() throws IOException, InterruptedException {
                return this.currentValue;
            }

            public float getProgress() throws IOException, InterruptedException {
                return reader.getProgress();
            }

            public void initialize(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                long preReadPos = reader.reader.getPosition();
                if (reader.nextKeyValue()) {
                    long postReadPos = reader.reader.getPosition();
                    ArcFileItemUtils.bytesWritableToArcFileItem(reader.getCurrentKey(), reader.getCurrentValue(), this.currentValue);
                    this.currentValue.setArcFileName(((FileSplit)split).getPath().getName());
                    this.currentValue.setArcFilePos((int)preReadPos);
                    this.currentValue.setArcFileSize((int)(postReadPos - preReadPos));
                    return true;
                }
                return false;
            }
        };
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        ArrayList candidateList = (ArrayList)super.listStatus(job);
        for (int i = 0; i < candidateList.size(); ++i) {
            Path pathAtIndex = ((FileStatus)candidateList.get(i)).getPath();
            if (pathAtIndex.getName().endsWith("arc.gz")) continue;
            candidateList.remove(i);
            --i;
        }
        return candidateList;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }
}

