/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.commoncrawl.hadoop.io.mapreduce.ARCFileRecordReader;

public class ARCFileInputFormat
extends FileInputFormat<Text, BytesWritable> {
    static final String ARC_SUFFIX = "arc.gz";
    public static final String USE_S3_INPUTSTREAM = "fs.s3n.use.s3inputstream";

    public RecordReader<Text, BytesWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        ARCFileRecordReader reader = new ARCFileRecordReader();
        reader.initialize(split, context);
        return reader;
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        ArrayList candidateList = (ArrayList)super.listStatus(job);
        for (int i = 0; i < candidateList.size(); ++i) {
            Path pathAtIndex = ((FileStatus)candidateList.get(i)).getPath();
            if (pathAtIndex.getName().endsWith(ARC_SUFFIX)) continue;
            candidateList.remove(i);
            --i;
        }
        return candidateList;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return false;
    }
}

