/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.deprecated;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.commoncrawl.hadoop.io.deprecated.ARCResource;
import org.commoncrawl.hadoop.io.deprecated.ARCSource;
import org.commoncrawl.hadoop.io.deprecated.ARCSplitCalculator;
import org.commoncrawl.util.shared.EscapeUtils;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;

public class JetS3tARCSource
extends ARCSplitCalculator
implements ARCSource,
JobConfigurable {
    public static final String P_INPUT_PREFIXES = "jets3t.arc.source.input.prefixes.csv";
    public static final String P_AWS_ACCESS_KEY_ID = "jets3t.arc.source.aws.access.key.id";
    public static final String P_AWS_SECRET_ACCESS_KEY = "jets3t.arc.source.aws.secret.access.key";
    public static final String P_BUCKET_NAME = "jets3t.arc.source.bucket.name";
    public static final String P_MAX_TRIES = "jets3t.arc.source.max.tries";
    private static final Log LOG = LogFactory.getLog(JetS3tARCSource.class);
    private RestS3Service service;
    private S3Bucket bucket;
    private int maxTries;

    public static void setInputPrefixes(JobConf job, String ... prefixes) {
        job.set(P_INPUT_PREFIXES, EscapeUtils.concatenate(',', prefixes));
    }

    public static String[] getInputPrefixes(JobConf job) {
        String inputPrefixes = job.get(P_INPUT_PREFIXES);
        return inputPrefixes == null ? null : EscapeUtils.split(',', inputPrefixes);
    }

    public static final void setAWSAccessKeyID(JobConf job, String awsAccessKeyId) {
        job.set(P_AWS_ACCESS_KEY_ID, awsAccessKeyId);
    }

    public static final void setAWSSecretAccessKey(JobConf job, String awsSecretAccessKey) {
        job.set(P_AWS_SECRET_ACCESS_KEY, awsSecretAccessKey);
    }

    public static final void setBucketName(JobConf job, String bucketName) {
        job.set(P_BUCKET_NAME, bucketName);
    }

    public static final void setMaxRetries(JobConf job, int maxtries) {
        job.setInt(P_MAX_TRIES, maxtries);
    }

    @Override
    protected void configureImpl(JobConf job) {
        try {
            String awsAccessKeyId = this.getProperty(job, P_AWS_ACCESS_KEY_ID);
            String awsSecretAccessKey = this.getProperty(job, P_AWS_SECRET_ACCESS_KEY);
            String bucketName = this.getProperty(job, P_BUCKET_NAME);
            AWSCredentials awsCredentials = new AWSCredentials(awsAccessKeyId, awsSecretAccessKey);
            this.service = new RestS3Service(awsCredentials);
            this.bucket = new S3Bucket(bucketName);
            this.maxTries = job.getInt(P_MAX_TRIES, 4);
        }
        catch (S3ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    private String getProperty(JobConf job, String property) {
        String result = job.get(property);
        if (result == null) {
            throw new RuntimeException(property + " is not set");
        }
        return result;
    }

    @Override
    protected Collection<ARCResource> getARCResources(JobConf job) throws IOException {
        try {
            String[] inputPrefixes = JetS3tARCSource.getInputPrefixes(job);
            if (inputPrefixes == null) {
                throw new IllegalArgumentException("No inputs prefixes set");
            }
            HashMap<String, ARCResource> resources = new HashMap<String, ARCResource>();
            for (String prefix : JetS3tARCSource.getInputPrefixes(job)) {
                for (S3Object object : this.service.listObjects(this.bucket, prefix, null)) {
                    long length = object.getContentLength();
                    if (length <= 0L) continue;
                    String key = object.getKey();
                    resources.put(key, new ARCResource(key, length));
                }
            }
            return resources.values();
        }
        catch (S3ServiceException e) {
            throw new IOException(e.toString());
        }
    }

    @Override
    public InputStream getStream(String resource, long streamPosition, Throwable lastError, int previousFailures) throws Throwable {
        if (lastError == null || previousFailures < this.maxTries) {
            LOG.info((Object)("Opening " + resource + " at byte position " + streamPosition + ", attempt " + (previousFailures + 1) + " out of " + this.maxTries));
            S3Object object = this.service.getObject(this.bucket, resource, null, null, null, null, Long.valueOf(streamPosition), null);
            return object.getDataInputStream();
        }
        LOG.info((Object)("Too many failures for " + resource + ", aborting"));
        return null;
    }
}

