/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.io.deprecated;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.commoncrawl.hadoop.io.deprecated.ARCResource;
import org.commoncrawl.hadoop.io.deprecated.ARCSplit;

public abstract class ARCSplitCalculator
implements JobConfigurable {
    public static final String P_FILES_PER_SPLIT = "arc.split.calculator.files.per.split";
    public static final String P_MB_PER_SPLIT = "arc.split.calculator.mb.per.split";
    private int filesPerSplit;
    private long bytesPerSplit;

    public static final void setFilesPerSplit(JobConf job, int filesPerSplit) {
        job.setInt(P_FILES_PER_SPLIT, filesPerSplit);
    }

    public static final void setMegabytesPerSplit(JobConf job, int mbPerSplit) {
        job.setInt(P_MB_PER_SPLIT, mbPerSplit);
    }

    public final void configure(JobConf job) {
        this.filesPerSplit = job.getInt(P_FILES_PER_SPLIT, 1);
        this.bytesPerSplit = job.get(P_MB_PER_SPLIT) == null ? Long.MAX_VALUE : Long.parseLong(job.get(P_MB_PER_SPLIT)) * 1024L * 1024L;
        this.configureImpl(job);
    }

    protected void configureImpl(JobConf job) {
    }

    protected abstract Collection<ARCResource> getARCResources(JobConf var1) throws IOException;

    public ARCSplit[] getARCSplits(JobConf job) throws IOException {
        LinkedList<ARCSplit> splits = new LinkedList<ARCSplit>();
        ARCResource[] resources = new ARCResource[this.filesPerSplit];
        int nResources = 0;
        long length = 0L;
        for (ARCResource resource : this.getARCResources(job)) {
            resources[nResources++] = resource;
            if (nResources < this.filesPerSplit && (length += resource.getSize()) < this.bytesPerSplit) continue;
            this.addSplit(splits, resources, nResources);
            nResources = 0;
            length = 0L;
        }
        this.addSplit(splits, resources, nResources);
        return splits.toArray(new ARCSplit[splits.size()]);
    }

    private void addSplit(List<ARCSplit> splits, ARCResource[] resources, int size) {
        if (size > 0) {
            ARCResource[] copy = new ARCResource[size];
            System.arraycopy(resources, 0, copy, 0, size);
            splits.add(new ARCSplit(copy));
        }
    }
}

