/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.hadoop.emr.sample;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.commoncrawl.hadoop.io.mapred.ARCFileInputFormat;
import org.commoncrawl.util.shared.ByteArrayUtils;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.JobBuilder;

public class BareBonesJob
implements Mapper<Text, BytesWritable, NullWritable, NullWritable> {
    private static final Log LOG = LogFactory.getLog(BareBonesJob.class);
    static Options options = new Options();

    static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("BareBonesJob", options);
    }

    public static void main(String[] args) {
        GnuParser parser = new GnuParser();
        try {
            CommandLine cmdLine = parser.parse(options, args);
            JobBuilder builder = new JobBuilder("BareBones Job", new Configuration());
            LOG.info((Object)("Paths:" + cmdLine.getOptionValues("path")));
            if (cmdLine.hasOption("path")) {
                for (String path : cmdLine.getOptionValues("path")) {
                    LOG.info((Object)("Adding Input Path:" + path));
                    builder.input(new Path(path));
                }
            } else {
                throw new IOException("No Paths Specified!");
            }
            builder.keyValue(NullWritable.class, NullWritable.class);
            builder.mapper(BareBonesJob.class);
            builder.inputFormat(ARCFileInputFormat.class);
            builder.outputFormat(NullOutputFormat.class);
            builder.numReducers(0);
            JobConf job = builder.build();
            JobClient.runJob((JobConf)job);
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            System.exit(1);
        }
        catch (ParseException e) {
            System.out.println(e.toString());
            BareBonesJob.printUsage();
            System.exit(1);
        }
    }

    public void configure(JobConf job) {
        LOG.info((Object)("Source File:" + job.get("map.input.file")));
    }

    public void close() throws IOException {
    }

    public void map(Text key, BytesWritable value, OutputCollector<NullWritable, NullWritable> output, Reporter reporter) throws IOException {
        int indexOfTrailingCRLF = ByteArrayUtils.indexOf(value.getBytes(), 0, value.getLength(), "\r\n\r\n".getBytes());
        int headerLen = indexOfTrailingCRLF + 4;
        int contentLen = value.getLength() - headerLen;
        String outputStr = "Key:" + key.toString() + " HeaderLen:" + headerLen + " ContentLen:" + contentLen;
        System.out.println(outputStr);
    }

    static {
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Input Path");
        options.addOption(OptionBuilder.create((String)"path"));
    }
}

