/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.api;

import java.util.ArrayList;
import java.util.List;
import org.collectd.api.DataSet;
import org.collectd.api.DataSource;
import org.collectd.api.PluginData;

public class ValueList
extends PluginData {
    private List<Number> _values = new ArrayList<Number>();
    private DataSet _ds;
    private long _interval = 0L;

    public ValueList() {
    }

    public ValueList(PluginData pluginData) {
        super(pluginData);
    }

    public ValueList(ValueList valueList) {
        this((PluginData)valueList);
        this._interval = valueList._interval;
        this._values.addAll(valueList.getValues());
        this._ds = valueList._ds;
    }

    public List<Number> getValues() {
        return this._values;
    }

    public void setValues(List<Number> list) {
        this._values = list;
    }

    public void addValue(Number number) {
        this._values.add(number);
    }

    public void clearValues() {
        this._values.clear();
    }

    public List<DataSource> getDataSource() {
        if (this._ds == null) {
            return null;
        }
        return this._ds.getDataSources();
    }

    public DataSet getDataSet() {
        return this._ds;
    }

    public void setDataSet(DataSet dataSet) {
        this._ds = dataSet;
    }

    public void setDataSource(List<DataSource> list) {
        this._ds = new DataSet(this._type, list);
    }

    public long getInterval() {
        return this._interval;
    }

    public void setInterval(long l) {
        this._interval = l;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("=[");
        List<DataSource> list = this.getDataSource();
        int n = this._values.size();
        for (int i = 0; i < n; ++i) {
            Number number = this._values.get(i);
            String string = list == null ? "unknown" + i : list.get(i).getName();
            stringBuffer.append(string).append('=').append(number);
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

