/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.api;

import org.collectd.api.PluginData;

public class Notification
extends PluginData {
    public static final int FAILURE = 1;
    public static final int WARNING = 2;
    public static final int OKAY = 4;
    public static String[] SEVERITY = new String[]{"FAILURE", "WARNING", "OKAY", "UNKNOWN"};
    private int _severity = 0;
    private String _message = "Initial notification message";

    public Notification() {
    }

    public Notification(PluginData pluginData) {
        super(pluginData);
    }

    public void setSeverity(int n) {
        if (n == 1 || n == 2 || n == 4) {
            this._severity = n;
        }
    }

    public int getSeverity() {
        return this._severity;
    }

    public String getSeverityString() {
        switch (this._severity) {
            case 1: {
                return SEVERITY[0];
            }
            case 2: {
                return SEVERITY[1];
            }
            case 4: {
                return SEVERITY[2];
            }
        }
        return SEVERITY[3];
    }

    public void setMessage(String string) {
        this._message = string;
    }

    public String getMessage() {
        return this._message;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" [").append(this.getSeverityString()).append("] ");
        stringBuffer.append(this._message);
        return stringBuffer.toString();
    }
}

