/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wsdl.xml;

import com.idoox.util.xml.DOMWriter;
import com.idoox.wsdl.util.XmlUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLWriterImpl
implements WSDLWriter {
    public static final String FEATURE_INDENT = "indent";
    public static final String FEATURE_SORT = "sort";
    private boolean doIndent = true;
    private boolean doSort = true;
    private static final Comparator COMPARATOR_QNAMES = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof QName && o2 instanceof QName) {
                QName q1 = (QName)o1;
                QName q2 = (QName)o2;
                if (q1.getNamespaceURI() != null) {
                    int result = q1.getNamespaceURI().compareTo(q2.getNamespaceURI());
                    return result == 0 ? q1.getLocalPart().compareTo(q2.getLocalPart()) : result;
                }
            }
            return 0;
        }
    };
    private static final Comparator COMPARATOR_OPERATIONS = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Operation && o2 instanceof Operation) {
                Operation op1 = (Operation)o1;
                Operation op2 = (Operation)o2;
                if (op1.getName() != null) {
                    return op1.getName().compareTo(op2.getName());
                }
            }
            return 0;
        }
    };
    private static final Comparator COMPARATOR_BINDING_OPERATIONS = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof BindingOperation && o2 instanceof BindingOperation) {
                BindingOperation op1 = (BindingOperation)o1;
                BindingOperation op2 = (BindingOperation)o2;
                if (op1.getName() != null) {
                    return op1.getName().compareTo(op2.getName());
                }
            }
            return 0;
        }
    };
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$javax$wsdl$Types;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$javax$wsdl$BindingOperation;
    static /* synthetic */ Class class$javax$wsdl$BindingInput;
    static /* synthetic */ Class class$javax$wsdl$BindingOutput;
    static /* synthetic */ Class class$javax$wsdl$BindingFault;
    static /* synthetic */ Class class$javax$wsdl$Port;
    static /* synthetic */ Class class$javax$wsdl$Service;

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (FEATURE_INDENT.equals(name)) {
            this.doIndent = value;
        } else if (FEATURE_SORT.equals(name)) {
            this.doSort = value;
        } else {
            throw new IllegalArgumentException("Feature name '" + name + "'" + "not recognized");
        }
    }

    public boolean getFeature(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (FEATURE_INDENT.equals(name)) {
            return this.doIndent;
        }
        if (FEATURE_SORT.equals(name)) {
            return this.doSort;
        }
        throw new IllegalArgumentException("Feature name '" + name + "'" + "not recognized");
    }

    public Document getDocument(Definition wsdlDef) throws WSDLException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.writeWSDL(wsdlDef, pw);
        StringReader sr = new StringReader(sw.toString());
        InputSource is = new InputSource(sr);
        return WSDLWriterImpl.parseDocument(is);
    }

    public void writeWSDL(Definition wsdlDef, Writer sink) throws WSDLException {
        WSDLWriterImpl.generateWSDL(wsdlDef, sink, this.doIndent, this.doSort);
    }

    public void writeWSDL(Definition wsdlDef, OutputStream sink) throws WSDLException {
        OutputStreamWriter writer = new OutputStreamWriter(sink);
        WSDLWriterImpl.generateWSDL(wsdlDef, writer, this.doIndent, this.doSort);
        try {
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Document parseDocument(InputSource is) throws WSDLException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            return doc;
        }
        catch (Throwable t) {
            throw new WSDLException("PARSER_ERROR", "Error parsing WSDL string ", t);
        }
    }

    private static void generateWSDL(Definition def, Writer sink, boolean doIndent, boolean doSort) throws WSDLException {
        try {
            String wsdlString = WSDLWriterImpl.generateDefinitions(def, doIndent, doSort);
            sink.write(wsdlString);
        }
        catch (IOException io) {
            throw new WSDLException("OTHER_ERROR", "Can't write to writer: " + io.getMessage());
        }
    }

    private static String generateDefinitions(Definition def, boolean doIndent, boolean doSort) throws WSDLException {
        PrintWriter pw;
        StringBuffer strBuffer = new StringBuffer();
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = pw = doIndent ? new IndentWriter(strWriter) : new PrintWriter(strWriter);
        if (def.getDocumentationElement() != null) {
            WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)def.getDocumentationElement()), 4);
        }
        WSDLWriterImpl.generateImports(def, pw);
        if (def.getTypes() != null) {
            WSDLWriterImpl.generateTypes(def, pw, doIndent);
        }
        WSDLWriterImpl.generateMessages(def, pw, doSort);
        WSDLWriterImpl.generatePortTypes(def, pw, doSort);
        WSDLWriterImpl.generateBindings(def, pw, doSort);
        WSDLWriterImpl.generateServices(def, pw, doSort);
        List extEL = def.getExtensibilityElements();
        WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = WSDLWriterImpl.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, extEL, def, pw);
        String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
        String definitionNamespace = XmlUtil.printAttr((String)"targetNamespace", (Object)def.getTargetNamespace());
        String definitionName = def.getQName() != null ? XmlUtil.printAttr((String)"name", (Object)def.getQName().getLocalPart()) : null;
        strBuffer.append("<?xml version='1.0' encoding='utf-8' ?>");
        if (doIndent) {
            strBuffer.append("\n");
        }
        strBuffer.append("<");
        strBuffer.append(wsdlPrefix);
        strBuffer.append("definitions");
        if (definitionName != null) {
            strBuffer.append(definitionName);
        }
        if (definitionNamespace != null && definitionNamespace.length() > 0) {
            strBuffer.append(definitionNamespace);
        }
        strBuffer.append(WSDLWriterImpl.getMappedNamespaces(def));
        strBuffer.append(">");
        if (doIndent) {
            strBuffer.append("\n");
        }
        strBuffer.append(strWriter.toString());
        strBuffer.append("</");
        strBuffer.append(wsdlPrefix);
        strBuffer.append("definitions>");
        return strBuffer.toString();
    }

    private static void generateTypes(Definition def, PrintWriter pw, boolean doIndent) throws WSDLException {
        String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
        Element typesDoc = def.getTypes().getDocumentationElement();
        List typesL = def.getTypes().getExtensibilityElements();
        pw.print("<" + wsdlPrefix + "types>" + (doIndent ? "\n" : ""));
        if (typesDoc != null) {
            WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)typesDoc), 8);
        }
        WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Types == null ? (class$javax$wsdl$Types = WSDLWriterImpl.class$("javax.wsdl.Types")) : class$javax$wsdl$Types, typesL, def, pw);
        pw.print("</" + wsdlPrefix + "types>");
    }

    private static void generateImports(Definition def, PrintWriter pw) throws WSDLException {
        String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
        Collection imports = def.getImports().values();
        if (imports == null) {
            return;
        }
        Iterator impListI = imports.iterator();
        while (impListI.hasNext()) {
            Iterator impI = ((List)impListI.next()).iterator();
            while (impI.hasNext()) {
                Import imp = (Import)impI.next();
                pw.print("<" + wsdlPrefix + "import" + XmlUtil.printAttr((String)"namespace", (Object)imp.getNamespaceURI()) + XmlUtil.printAttr((String)"location", (Object)imp.getLocationURI()) + "/>");
            }
        }
    }

    private static void generateMessages(Definition def, PrintWriter pw, boolean doSort) throws WSDLException {
        Iterator msgI;
        String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
        if (doSort) {
            TreeMap sortedMsgs = new TreeMap(COMPARATOR_QNAMES);
            sortedMsgs.putAll(def.getMessages());
            msgI = sortedMsgs.values().iterator();
        } else {
            msgI = def.getMessages().values().iterator();
        }
        while (msgI.hasNext()) {
            Message msg = (Message)msgI.next();
            pw.print("<" + wsdlPrefix + "message" + XmlUtil.printAttr((String)"name", (Object)msg.getQName().getLocalPart()));
            Element docEl = msg.getDocumentationElement();
            Iterator partI = msg.getOrderedParts(null).iterator();
            if (!partI.hasNext() && docEl == null) {
                pw.print("/>");
                continue;
            }
            pw.print(">");
            if (docEl != null) {
                WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)docEl), 8);
            }
            while (partI.hasNext()) {
                Part part = (Part)partI.next();
                Element partDocEl = part.getDocumentationElement();
                pw.print("<" + wsdlPrefix + "part" + XmlUtil.printAttr((String)"name", (Object)part.getName()) + XmlUtil.printAttr((String)"element", (Object)XmlUtil.toAttr((Definition)def, (QName)part.getElementName())) + XmlUtil.printAttr((String)"type", (Object)XmlUtil.toAttr((Definition)def, (QName)part.getTypeName())));
                if (partDocEl == null) {
                    pw.print("/>");
                    continue;
                }
                pw.print(">");
                WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)partDocEl), 12);
                pw.print("</" + wsdlPrefix + "part>");
            }
            pw.print("</" + wsdlPrefix + "message>");
        }
    }

    private static void generatePortTypes(Definition def, PrintWriter pw, boolean doSort) throws WSDLException {
        Iterator portTypesI;
        String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
        if (doSort) {
            TreeMap sortedPortTypes = new TreeMap(COMPARATOR_QNAMES);
            sortedPortTypes.putAll(def.getPortTypes());
            portTypesI = sortedPortTypes.values().iterator();
        } else {
            portTypesI = def.getPortTypes().values().iterator();
        }
        while (portTypesI.hasNext()) {
            Iterator opsI;
            PortType portType = (PortType)portTypesI.next();
            pw.print("<" + wsdlPrefix + "portType" + XmlUtil.printAttr((String)"name", (Object)portType.getQName().getLocalPart()));
            Element docEl = portType.getDocumentationElement();
            List operationsList = portType.getOperations();
            if (doSort) {
                Collections.sort(operationsList, COMPARATOR_OPERATIONS);
            }
            if (!(opsI = portType.getOperations().iterator()).hasNext()) {
                pw.print("/>");
                continue;
            }
            pw.print(">");
            if (docEl != null) {
                WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)docEl), 8);
            }
            while (opsI.hasNext()) {
                Fault fault;
                Iterator faultI;
                Output output;
                Element inopDocEl;
                Input input;
                Operation op = (Operation)opsI.next();
                pw.print("<" + wsdlPrefix + "operation" + XmlUtil.printAttr((String)"name", (Object)op.getName()) + XmlUtil.printAttr((String)"parameterOrder", (Object)op.getParameterOrdering()) + ">");
                Element opDocEl = op.getDocumentationElement();
                if (opDocEl != null) {
                    WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)opDocEl), 12);
                }
                if (op.getStyle() == OperationType.ONE_WAY) {
                    input = op.getInput();
                    pw.print("<" + wsdlPrefix + "input" + XmlUtil.printAttr((String)"name", (Object)input.getName()) + XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)input.getMessage().getQName())));
                    inopDocEl = input.getDocumentationElement();
                    if (inopDocEl == null) {
                        pw.print("/>");
                    } else {
                        pw.print(">");
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)inopDocEl), 16);
                        pw.print("</" + wsdlPrefix + "input>");
                    }
                } else if (op.getStyle() == OperationType.NOTIFICATION) {
                    output = op.getOutput();
                    pw.print("<" + wsdlPrefix + "output" + XmlUtil.printAttr((String)"name", (Object)output.getName()) + XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)output.getMessage().getQName())));
                    inopDocEl = output.getDocumentationElement();
                    if (inopDocEl == null) {
                        pw.print("/>");
                    } else {
                        pw.print(">");
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)inopDocEl), 16);
                        pw.print("</" + wsdlPrefix + "output>");
                    }
                } else if (op.getStyle() == OperationType.REQUEST_RESPONSE) {
                    input = op.getInput();
                    pw.print("<" + wsdlPrefix + "input" + XmlUtil.printAttr((String)"name", (Object)input.getName()) + XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)input.getMessage().getQName())));
                    inopDocEl = input.getDocumentationElement();
                    if (inopDocEl == null) {
                        pw.print("/>");
                    } else {
                        pw.print(">");
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)inopDocEl), 16);
                        pw.print("</" + wsdlPrefix + "input>");
                    }
                    Output output2 = op.getOutput();
                    pw.print("<" + wsdlPrefix + "output" + XmlUtil.printAttr((String)"name", (Object)output2.getName()) + XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)output2.getMessage().getQName())));
                    inopDocEl = output2.getDocumentationElement();
                    if (inopDocEl == null) {
                        pw.print("/>");
                    } else {
                        pw.print(">");
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)inopDocEl), 16);
                        pw.print("</" + wsdlPrefix + "output>");
                    }
                    faultI = op.getFaults().values().iterator();
                    while (faultI.hasNext()) {
                        fault = (Fault)faultI.next();
                        pw.print("<" + wsdlPrefix + "fault" + XmlUtil.printAttr((String)"name", (Object)fault.getName()) + XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)fault.getMessage().getQName())));
                        inopDocEl = fault.getDocumentationElement();
                        if (inopDocEl == null) {
                            pw.print("/>");
                            continue;
                        }
                        pw.print(">");
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)inopDocEl), 16);
                        pw.print("</" + wsdlPrefix + "fault>");
                    }
                } else if (op.getStyle() == OperationType.SOLICIT_RESPONSE) {
                    output = op.getOutput();
                    pw.print("<" + wsdlPrefix + "output" + XmlUtil.printAttr((String)"name", (Object)output.getName()) + XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)output.getMessage().getQName())));
                    inopDocEl = output.getDocumentationElement();
                    if (inopDocEl == null) {
                        pw.print("/>");
                    } else {
                        pw.print(">");
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)inopDocEl), 16);
                        pw.print("</" + wsdlPrefix + "output>");
                    }
                    Input input2 = op.getInput();
                    pw.print("<" + wsdlPrefix + "input" + XmlUtil.printAttr((String)"name", (Object)input2.getName()) + XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)input2.getMessage().getQName())));
                    inopDocEl = input2.getDocumentationElement();
                    if (inopDocEl == null) {
                        pw.print("/>");
                    } else {
                        pw.print(">");
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)inopDocEl), 16);
                        pw.print("</" + wsdlPrefix + "input>");
                    }
                    faultI = op.getFaults().values().iterator();
                    while (faultI.hasNext()) {
                        fault = (Fault)faultI.next();
                        pw.print("<" + wsdlPrefix + "fault" + XmlUtil.printAttr((String)"name", (Object)fault.getName()) + XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)fault.getMessage().getQName())));
                        inopDocEl = fault.getDocumentationElement();
                        if (inopDocEl == null) {
                            pw.print("/>");
                            continue;
                        }
                        pw.print(">");
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)inopDocEl), 16);
                        pw.print("</" + wsdlPrefix + "fault>");
                    }
                }
                pw.print("</" + wsdlPrefix + "operation>");
            }
            pw.print("</" + wsdlPrefix + "portType>");
        }
    }

    private static void generateBindings(Definition def, PrintWriter pw, boolean doSort) throws WSDLException {
        Iterator bindingsI;
        String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
        if (doSort) {
            TreeMap sortedBindings = new TreeMap(COMPARATOR_QNAMES);
            sortedBindings.putAll(def.getBindings());
            bindingsI = sortedBindings.values().iterator();
        } else {
            bindingsI = def.getBindings().values().iterator();
        }
        while (bindingsI.hasNext()) {
            Binding binding = (Binding)bindingsI.next();
            pw.print("<" + wsdlPrefix + "binding" + XmlUtil.printAttr((String)"name", (Object)binding.getQName().getLocalPart()) + XmlUtil.printAttr((String)"type", (Object)XmlUtil.toAttr((Definition)def, (QName)binding.getPortType().getQName())));
            List extEL = binding.getExtensibilityElements();
            List operationsList = binding.getBindingOperations();
            if (doSort) {
                Collections.sort(operationsList, COMPARATOR_BINDING_OPERATIONS);
            }
            Iterator bOpsI = binding.getBindingOperations().iterator();
            Element docEl = binding.getDocumentationElement();
            if (extEL.isEmpty() && !bOpsI.hasNext() && docEl == null) {
                pw.print("/>");
                continue;
            }
            pw.print(">");
            if (docEl != null) {
                WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)docEl), 8);
            }
            WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Binding == null ? WSDLWriterImpl.class$("javax.wsdl.Binding") : class$javax$wsdl$Binding, extEL, def, pw);
            while (bOpsI.hasNext()) {
                BindingOperation bOp = (BindingOperation)bOpsI.next();
                pw.print("<" + wsdlPrefix + "operation" + XmlUtil.printAttr((String)"name", (Object)bOp.getName()));
                List bOpEL = bOp.getExtensibilityElements();
                Iterator bOpFaultsI = bOp.getBindingFaults().values().iterator();
                if (bOp.getDocumentationElement() == null && bOp.getBindingInput() == null && bOp.getBindingOutput() == null && !bOpFaultsI.hasNext() && bOpEL.isEmpty()) {
                    pw.print("/>");
                    continue;
                }
                pw.print(">");
                if (bOp.getDocumentationElement() != null) {
                    WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)bOp.getDocumentationElement()), 12);
                }
                WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$BindingOperation == null ? WSDLWriterImpl.class$("javax.wsdl.BindingOperation") : class$javax$wsdl$BindingOperation, bOpEL, def, pw);
                if (bOp.getBindingInput() != null) {
                    BindingInput bInput = bOp.getBindingInput();
                    pw.print("<" + wsdlPrefix + "input" + XmlUtil.printAttr((String)"name", (Object)bInput.getName()));
                    List bInputEL = bInput.getExtensibilityElements();
                    if (bInput.getDocumentationElement() == null && bInputEL.isEmpty()) {
                        pw.print("/>");
                    } else {
                        pw.print(">");
                        if (bInput.getDocumentationElement() != null) {
                            WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)bInput.getDocumentationElement()), 16);
                        }
                        WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$BindingInput == null ? WSDLWriterImpl.class$("javax.wsdl.BindingInput") : class$javax$wsdl$BindingInput, bInputEL, def, pw);
                        pw.print("</" + wsdlPrefix + "input>");
                    }
                }
                if (bOp.getBindingOutput() != null) {
                    BindingOutput bOutput = bOp.getBindingOutput();
                    pw.print("<" + wsdlPrefix + "output" + XmlUtil.printAttr((String)"name", (Object)bOutput.getName()));
                    List bOutputEL = bOutput.getExtensibilityElements();
                    if (bOutput.getDocumentationElement() == null && bOutputEL.isEmpty()) {
                        pw.print("/>");
                    } else {
                        pw.print(">");
                        if (bOutput.getDocumentationElement() != null) {
                            WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)bOutput.getDocumentationElement()), 16);
                        }
                        WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$BindingOutput == null ? WSDLWriterImpl.class$("javax.wsdl.BindingOutput") : class$javax$wsdl$BindingOutput, bOutputEL, def, pw);
                        pw.print("</" + wsdlPrefix + "output>");
                    }
                }
                while (bOpFaultsI.hasNext()) {
                    BindingFault bFault = (BindingFault)bOpFaultsI.next();
                    pw.print("<" + wsdlPrefix + "fault" + XmlUtil.printAttr((String)"name", (Object)bFault.getName()));
                    List bFaultEL = bFault.getExtensibilityElements();
                    if (bFault.getDocumentationElement() == null && bFaultEL.isEmpty()) {
                        pw.print("/>");
                        continue;
                    }
                    pw.print(">");
                    if (bFault.getDocumentationElement() != null) {
                        WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)bFault.getDocumentationElement()), 16);
                    }
                    WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$BindingFault == null ? WSDLWriterImpl.class$("javax.wsdl.BindingFault") : class$javax$wsdl$BindingFault, bFaultEL, def, pw);
                    pw.print("</" + wsdlPrefix + "fault>");
                }
                pw.print("</" + wsdlPrefix + "operation>");
            }
            pw.print("</" + wsdlPrefix + "binding>");
        }
    }

    private static void generateServices(Definition def, PrintWriter pw, boolean doSort) throws WSDLException {
        Iterator servicesI;
        String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
        if (doSort) {
            TreeMap sortedServices = new TreeMap(COMPARATOR_QNAMES);
            sortedServices.putAll(def.getServices());
            servicesI = sortedServices.values().iterator();
        } else {
            servicesI = def.getServices().values().iterator();
        }
        while (servicesI.hasNext()) {
            Iterator portsI;
            Service service = (Service)servicesI.next();
            pw.print("<" + wsdlPrefix + "service" + XmlUtil.printAttr((String)"name", (Object)service.getQName().getLocalPart()));
            if (doSort) {
                TreeMap sortedPorts = new TreeMap();
                sortedPorts.putAll(service.getPorts());
                portsI = sortedPorts.values().iterator();
            } else {
                portsI = service.getPorts().values().iterator();
            }
            List extEL = service.getExtensibilityElements();
            if (service.getDocumentationElement() == null && !portsI.hasNext() && extEL.isEmpty()) {
                pw.print("/>");
                continue;
            }
            pw.print(">");
            if (service.getDocumentationElement() != null) {
                WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)service.getDocumentationElement()), 8);
            }
            while (portsI.hasNext()) {
                Port port = (Port)portsI.next();
                pw.print("<" + wsdlPrefix + "port" + XmlUtil.printAttr((String)"name", (Object)port.getName()) + XmlUtil.printAttr((String)"binding", (Object)XmlUtil.toAttr((Definition)def, (QName)port.getBinding().getQName())));
                List portExtEL = port.getExtensibilityElements();
                if (port.getDocumentationElement() == null && portExtEL.isEmpty()) {
                    pw.print("/>");
                    continue;
                }
                pw.print(">");
                if (port.getDocumentationElement() != null) {
                    WSDLWriterImpl.writeElement(pw, XmlUtil.smarterCloneElement((Definition)def, (Element)port.getDocumentationElement()), 12);
                }
                WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Port == null ? WSDLWriterImpl.class$("javax.wsdl.Port") : class$javax$wsdl$Port, portExtEL, def, pw);
                pw.print("</" + wsdlPrefix + "port>");
            }
            WSDLWriterImpl.printExtensibilityElements(class$javax$wsdl$Service == null ? WSDLWriterImpl.class$("javax.wsdl.Service") : class$javax$wsdl$Service, extEL, def, pw);
            pw.print("</" + wsdlPrefix + "service>");
        }
    }

    private static String getMappedNamespaces(Definition def) {
        StringBuffer toRet = new StringBuffer();
        Map namespaceMap = def.getNamespaces();
        Iterator prefixI = namespaceMap.keySet().iterator();
        while (prefixI.hasNext()) {
            String prefix = (String)prefixI.next();
            toRet.append(XmlUtil.printAttr((String)("\n    xmlns" + (prefix.length() > 0 ? ":" + prefix : "")), (Object)((String)namespaceMap.get(prefix))));
        }
        return toRet.toString();
    }

    private static void printExtensibilityElements(Class parentType, List elements, Definition def, PrintWriter pw) throws WSDLException {
        if (elements == null) {
            return;
        }
        Iterator elIter = elements.iterator();
        while (elIter.hasNext()) {
            ExtensibilityElement extEl = (ExtensibilityElement)elIter.next();
            QName extElType = extEl.getElementType();
            ExtensionRegistry extReg = def.getExtensionRegistry();
            if (extReg == null) {
                throw new WSDLException("CONFIGURATION_ERROR", "Definition has no ExtensionRegistry set.");
            }
            ExtensionSerializer extSer = extReg.querySerializer(parentType, extElType);
            extSer.marshall(parentType, extElType, extEl, pw, def, extReg);
        }
    }

    private static void writeElement(PrintWriter pw, Element e, int indentLevel) {
        try {
            pw.write(DOMWriter.serialize((Element)e, (boolean)true, (boolean)true, (int)indentLevel));
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot serialize element: " + exception.getMessage());
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class IndentWriter
    extends PrintWriter {
        private int indentSize = 1;
        private static final String wsStr = "                                                                                                                                            ";

        public IndentWriter(Writer toWr) {
            super(toWr);
            this.out = toWr;
        }

        public void print(String str) {
            if (str == null) {
                return;
            }
            String toPr = str;
            if (str.startsWith("</")) {
                --this.indentSize;
                toPr = IndentWriter.mkWS(this.indentSize * 4) + toPr;
            } else if (str.startsWith("<")) {
                toPr = IndentWriter.mkWS(this.indentSize * 4) + toPr;
                ++this.indentSize;
            }
            if (str.endsWith("/>")) {
                --this.indentSize;
                toPr = toPr + "\n";
            } else if (str.endsWith(">")) {
                toPr = toPr + "\n";
            }
            super.print(toPr);
        }

        private static String mkWS(int len) {
            if (len <= wsStr.length()) {
                return wsStr.substring(0, len);
            }
            StringBuffer sB = new StringBuffer();
            int wsStrLen = wsStr.length();
            while (len > 0) {
                int aLen = len > wsStrLen ? wsStrLen : len;
                sB.append(wsStr.substring(0, aLen));
                len -= aLen;
            }
            return sB.toString();
        }
    }
}

