/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wsdl.extensions.soap;

import com.idoox.wsdl.extensions.soap.SOAPHeader;
import com.idoox.wsdl.extensions.soap.SOAPHeaderFault;
import com.idoox.wsdl.util.XmlUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPHeaderSerializer
implements ExtensionSerializer,
ExtensionDeserializer,
Serializable {
    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition def, ExtensionRegistry extReg) throws WSDLException {
        List shfs;
        SOAPHeader extEl = (SOAPHeader)extension;
        String soapPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/soap/");
        pw.print("<" + soapPrefix + "header");
        pw.print(XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)extEl.getMessage())));
        pw.print(XmlUtil.printAttr((String)"part", (Object)extEl.getPart()));
        pw.print(XmlUtil.printAttr((String)"use", (Object)extEl.getUse()));
        pw.print(XmlUtil.printAttr((String)"encodingStyle", (Object)extEl.getEncodingStyles()));
        pw.print(XmlUtil.printAttr((String)"namespace", (Object)extEl.getNamespaceURI()));
        if (extEl.getRequired() != null) {
            String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
            if ("".equals(wsdlPrefix)) {
                wsdlPrefix = "wsdl:";
                pw.print(" xmlns:wsdl='http://schemas.xmlsoap.org/wsdl/' ");
            }
            pw.print(XmlUtil.printAttr((String)(wsdlPrefix + "required"), (Object)extEl.getRequired()));
        }
        if ((shfs = extEl.getSOAPHeaderFaults()) == null || shfs.size() == 0) {
            pw.print("/>");
            return;
        }
        pw.print(">");
        int i = 0;
        while (i < shfs.size()) {
            SOAPHeaderFault shf = (SOAPHeaderFault)shfs.get(i);
            pw.print("<" + XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/soap/") + "headerfault");
            pw.print(XmlUtil.printAttr((String)"message", (Object)XmlUtil.toAttr((Definition)def, (QName)shf.getMessage())));
            pw.print(XmlUtil.printAttr((String)"part", (Object)shf.getPart()));
            pw.print(XmlUtil.printAttr((String)"use", (Object)shf.getUse()));
            pw.print(XmlUtil.printAttr((String)"encodingStyle", (Object)shf.getEncodingStyles()));
            pw.print(XmlUtil.printAttr((String)"namespace", (Object)shf.getNamespaceURI()));
            if (shf.getRequired() != null) {
                String wsdlPrefix = XmlUtil.getPrefix((Definition)def, (String)"http://schemas.xmlsoap.org/wsdl/");
                if ("".equals(wsdlPrefix)) {
                    wsdlPrefix = "wsdl:";
                    pw.print(" xmlns:wsdl='http://schemas.xmlsoap.org/wsdl/' ");
                }
                pw.print(XmlUtil.printAttr((String)(wsdlPrefix + "required"), (Object)shf.getRequired()));
            }
            pw.print("/>");
            ++i;
        }
        pw.print("</" + soapPrefix + "header>");
    }

    public ExtensibilityElement unmarshall(Class parentType, QName elementType, Element el, Definition def, ExtensionRegistry extReg) throws WSDLException {
        SOAPHeader ret = new SOAPHeader();
        ret.setMessage(XmlUtil.expandQName((Definition)def, (String)XmlUtil.getAttribute((Element)el, (String)"message")));
        ret.setPart(XmlUtil.getAttribute((Element)el, (String)"part"));
        ret.setUse(XmlUtil.getAttribute((Element)el, (String)"use"));
        ret.setEncodingStyles(XmlUtil.toList((String)XmlUtil.getAttribute((Element)el, (String)"encodingStyle")));
        ret.setNamespaceURI(XmlUtil.getAttribute((Element)el, (String)"namespace"));
        Element inRet = XmlUtil.getFirstChildElement((Node)el);
        while (inRet != null) {
            XmlUtil.checkElementName((Element)inRet, (QName)XmlUtil.SOAPHEADERFAULT_QNAME);
            SOAPHeaderFault shf = new SOAPHeaderFault();
            shf.setMessage(XmlUtil.expandQName((Definition)def, (String)XmlUtil.getAttribute((Element)inRet, (String)"message")));
            shf.setPart(XmlUtil.getAttribute((Element)inRet, (String)"part"));
            shf.setUse(XmlUtil.getAttribute((Element)inRet, (String)"use"));
            shf.setEncodingStyles(XmlUtil.toList((String)XmlUtil.getAttribute((Element)inRet, (String)"encodingStyle")));
            shf.setNamespaceURI(XmlUtil.getAttribute((Element)inRet, (String)"namespace"));
            String inrequired = XmlUtil.getAttributeNS((Element)inRet, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
            if (inrequired != null) {
                shf.setRequired(new Boolean(inrequired));
            }
            ret.addSOAPHeaderFault(shf);
            inRet = XmlUtil.getNextElementSibling((Node)inRet);
        }
        String required = XmlUtil.getAttributeNS((Element)el, (String)"http://schemas.xmlsoap.org/wsdl/", (String)"required");
        if (required != null) {
            ret.setRequired(new Boolean(required));
        }
        return ret;
    }
}

