/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.xml;

import com.idoox.debug.Category;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.systinet.xml.TokenizerInputSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class TokenizerXMLReader
implements XMLReader {
    private static final Category log = Category.getCategory((class$org$systinet$xml$TokenizerXMLReader == null ? (class$org$systinet$xml$TokenizerXMLReader = TokenizerXMLReader.class$("org.systinet.xml.TokenizerXMLReader")) : class$org$systinet$xml$TokenizerXMLReader).getName());
    private boolean namespacePrefixesFeature = false;
    private static final String DEF_ATTR_TYPE = "CDATA";
    private EntityResolver entityResolver = null;
    private DTDHandler dtdHadler = null;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private Tokenizer tokenizer = null;
    private final DeclaredPrefixesStack prefixStack = new DeclaredPrefixesStack();
    private int[] newPrefixesInLevel = new int[24];
    private Map[] ovewrittenMappings = new Map[24];
    private int currentLevel = 0;
    private final Map namespaceToPrefix = new HashMap();
    private Token token = new Token();
    private StringBuffer sb = new StringBuffer(25);
    private AttributesImpl attributes = new AttributesImpl();
    private char[] charsBuffer = new char[256];
    static /* synthetic */ Class class$org$systinet$xml$TokenizerXMLReader;
    static /* synthetic */ Class class$org$systinet$xml$TokenizerInputSource;

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return this.namespacePrefixesFeature;
        }
        throw new SAXNotRecognizedException("Feature " + name + " not recognized");
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            if (value) {
                return;
            }
            throw new SAXNotSupportedException("Cannot set " + name + " to false");
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this.namespacePrefixesFeature = value;
            return;
        }
        throw new SAXNotRecognizedException("Feature " + name + " not recognized");
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + name + " is not recognized");
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotRecognizedException("Property " + name + " is not recognized");
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHadler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHadler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (!(input instanceof TokenizerInputSource)) {
            throw new UnsupportedOperationException((class$org$systinet$xml$TokenizerInputSource == null ? (class$org$systinet$xml$TokenizerInputSource = TokenizerXMLReader.class$("org.systinet.xml.TokenizerInputSource")) : class$org$systinet$xml$TokenizerInputSource).toString() + " parses only " + (class$org$systinet$xml$TokenizerInputSource == null ? (class$org$systinet$xml$TokenizerInputSource = TokenizerXMLReader.class$("org.systinet.xml.TokenizerInputSource")) : class$org$systinet$xml$TokenizerInputSource).toString() + ", not " + input);
        }
        this.tokenizer = ((TokenizerInputSource)input).getTokenizer();
        if (this.tokenizer == null) {
            throw new NullPointerException("The tokenizer in " + input + " is null");
        }
        this.parse();
        this.tokenizer = null;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException((class$org$systinet$xml$TokenizerInputSource == null ? (class$org$systinet$xml$TokenizerInputSource = TokenizerXMLReader.class$("org.systinet.xml.TokenizerInputSource")) : class$org$systinet$xml$TokenizerInputSource).toString() + " parses only tokenizer, not systemId=" + systemId);
    }

    private void parse() throws SAXException {
        this.prefixStack.used = 0;
        this.currentLevel = 0;
        this.namespaceToPrefix.clear();
        this.contentHandler.startDocument();
        try {
            byte next = this.tokenizer.currentState();
            if (next != 2) {
                throw new IllegalStateException("The tokenizer is not on the START_TOKEN");
            }
            do {
                switch (next) {
                    case 2: {
                        this.pushTokenStart();
                        break;
                    }
                    case 3: {
                        this.pushTokenEnd();
                        break;
                    }
                    case 4: {
                        this.pushContent();
                        break;
                    }
                    default: {
                        throw new SAXException("Unknown token from tokenizer: " + next);
                    }
                }
            } while ((next = this.tokenizer.next()) != 1);
        }
        catch (TokenizerException e) {
            throw new SAXException(e);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.contentHandler.endDocument();
    }

    private void pushTokenStart() throws IOException, TokenizerException, SAXException {
        this.tokenizer.readToken(this.token);
        this.startPrefixMappings();
        String namespace = this.token.getNamespace();
        String localName = this.token.getLocalName();
        Attributes attrs = this.createAttributes();
        this.contentHandler.startElement(namespace, localName, this.createQName(namespace, localName), attrs);
        ++this.currentLevel;
    }

    private void startPrefixMappings() throws SAXException {
        int added = this.tokenizer.pushNewlyDeclaredPrefixes(this.prefixStack);
        this.ensureSize();
        this.newPrefixesInLevel[this.currentLevel] = added;
        int limit = this.prefixStack.used;
        int i = limit - added;
        while (i < limit) {
            String cprefix = this.prefixStack.prefixes[i];
            if (!"xml".equals(cprefix)) {
                String curi = this.prefixStack.prefixValues[i];
                this.contentHandler.startPrefixMapping(cprefix, curi);
                if (this.namespaceToPrefix.containsKey(curi)) {
                    if (this.ovewrittenMappings[this.currentLevel] == null) {
                        this.ovewrittenMappings[this.currentLevel] = new HashMap();
                    }
                    this.ovewrittenMappings[this.currentLevel].put(curi, this.namespaceToPrefix.get(curi));
                }
                this.namespaceToPrefix.put(curi, cprefix);
                String previousPrefixValue = this.prefixStack.previousPrefixValues[i];
                if (previousPrefixValue != null) {
                    this.namespaceToPrefix.values().remove(previousPrefixValue);
                }
            }
            ++i;
        }
    }

    private String createQName(String namespace, String localName) {
        String prefix;
        this.sb.delete(0, this.sb.length());
        String string = prefix = "http://www.w3.org/XML/1998/namespace".equals(namespace) ? "xml" : this.namespace2prefix(namespace);
        if (prefix != null) {
            this.sb.append(prefix);
            this.sb.append(':');
        }
        this.sb.append(localName);
        return this.sb.toString();
    }

    private String namespace2prefix(String namespace) {
        return (String)this.namespaceToPrefix.get(namespace);
    }

    private void ensureSize() {
        if (this.newPrefixesInLevel.length <= this.currentLevel) {
            int newSize = this.currentLevel * 3 / 2 + 1;
            int[] newArray = new int[newSize];
            System.arraycopy(this.newPrefixesInLevel, 0, newArray, 0, this.newPrefixesInLevel.length);
            this.newPrefixesInLevel = newArray;
            Map[] newMaps = new Map[newSize];
            System.arraycopy(this.ovewrittenMappings, 0, newMaps, 0, this.ovewrittenMappings.length);
            this.ovewrittenMappings = newMaps;
        }
    }

    private Attributes createAttributes() {
        this.attributes.clear();
        int i = 0;
        int limit = this.token.getAttributeCount();
        while (i < limit) {
            Attribute att = this.token.getAttribute(i);
            this.attributes.addAttribute(att.uri, att.localName, att.qName, DEF_ATTR_TYPE, att.value);
            ++i;
        }
        if (this.namespacePrefixesFeature) {
            int added = this.newPrefixesInLevel[this.currentLevel];
            int limit2 = this.prefixStack.used;
            int i2 = limit2 - added;
            while (i2 < limit2) {
                String cprefix = this.prefixStack.prefixes[i2];
                String curi = this.prefixStack.prefixValues[i2];
                String fullPrefix = cprefix == null ? "xmlns" : "xmlns:" + cprefix;
                this.attributes.addAttribute(null, fullPrefix, fullPrefix, DEF_ATTR_TYPE, curi);
                ++i2;
            }
        }
        return this.attributes;
    }

    private void pushTokenEnd() throws IOException, TokenizerException, SAXException {
        this.tokenizer.readToken(this.token);
        String namespace = this.token.getNamespace();
        String localName = this.token.getLocalName();
        this.contentHandler.endElement(namespace, localName, this.createQName(namespace, localName));
        this.endPrefixMappings();
    }

    private void endPrefixMappings() throws SAXException {
        --this.currentLevel;
        int toRemove = this.newPrefixesInLevel[this.currentLevel];
        int i = this.prefixStack.used - toRemove;
        while (i < this.prefixStack.used) {
            String cprefix = this.prefixStack.prefixes[i];
            if (!"xml".equals(cprefix)) {
                this.contentHandler.endPrefixMapping(cprefix);
                this.namespaceToPrefix.values().remove(cprefix);
                String previousPrefixValue = this.prefixStack.previousPrefixValues[i];
                if (previousPrefixValue != null) {
                    this.namespaceToPrefix.put(previousPrefixValue, cprefix);
                }
            }
            ++i;
        }
        Map map = this.ovewrittenMappings[this.currentLevel];
        if (map != null) {
            this.namespaceToPrefix.putAll(map);
            this.ovewrittenMappings[this.currentLevel] = null;
        }
        this.prefixStack.used -= toRemove;
    }

    private void pushContent() throws TokenizerException, SAXException {
        String content = this.tokenizer.readContent();
        int contentLength = content.length();
        if (contentLength > this.charsBuffer.length) {
            this.charsBuffer = new char[contentLength];
        }
        content.getChars(0, contentLength, this.charsBuffer, 0);
        this.contentHandler.characters(this.charsBuffer, 0, contentLength);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

