/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.webservice;

import com.idoox.util.ElementHelper;
import java.net.MalformedURLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.idoox.transport.client.Endpoint;
import org.systinet.wasp.addressing.EndpointReference;
import org.systinet.wasp.policy.DomainExpression;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.xml.XMLSourceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceEndpointReference
implements DomainExpression {
    private String path;
    private QName portType;
    private QName serviceName;
    private String portName;
    private static final String NS_URI = "http://systinet.com/wasp/policy/1.0";
    private static final String LOCAL_NAME = "ServiceEndpointReference";
    private static final QName ELEMENT_QNAME = new QName("http://systinet.com/wasp/policy/1.0", "ServiceEndpointReference");

    public ServiceEndpointReference(Source source) throws PolicyException {
        this.load(source);
    }

    public ServiceEndpointReference(String path) {
        this(path, null, null, null);
        this.path = path;
    }

    public ServiceEndpointReference(String path, QName portType, QName serviceName, String portName) {
        this.path = path;
        this.portName = portName;
        this.portType = portType;
        this.serviceName = serviceName;
    }

    public ServiceEndpointReference(ServiceEndpoint serviceEndpoint) {
        this(serviceEndpoint.getPath(), null, serviceEndpoint.getWSDLServiceName(), serviceEndpoint.getWSDLPortName());
    }

    public String getPath() {
        return this.path;
    }

    public String getPortName() {
        return this.portName;
    }

    public QName getPortType() {
        return this.portType;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceEndpointReference)) {
            return false;
        }
        ServiceEndpointReference reference = (ServiceEndpointReference)o;
        boolean bl = this.path != null ? !this.path.equals(reference.path) : reference.path != null;
        if (bl) {
            return false;
        }
        boolean bl2 = this.portName != null ? !this.portName.equals(reference.portName) : reference.portName != null;
        if (bl2) {
            return false;
        }
        boolean bl3 = this.portType != null ? !this.portType.equals(reference.portType) : reference.portType != null;
        if (bl3) {
            return false;
        }
        return !(this.serviceName != null ? !this.serviceName.equals(reference.serviceName) : reference.serviceName != null);
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 29 * result + (this.portType != null ? this.portType.hashCode() : 0);
        result = 29 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
        result = 29 * result + (this.portName != null ? this.portName.hashCode() : 0);
        return result;
    }

    public boolean includes(DomainExpression domainExpression) {
        if (domainExpression == null) {
            return false;
        }
        if (domainExpression instanceof ServiceEndpointReference) {
            boolean portNameInclude;
            ServiceEndpointReference o = (ServiceEndpointReference)domainExpression;
            if (this.equals(o)) {
                return true;
            }
            boolean addressInclude = this.path == null ? true : this.path.equals(o.path);
            boolean portTypeInclude = this.portType == null ? true : this.portType.equals(o.portType);
            boolean serviceNameInclude = this.serviceName == null ? true : this.serviceName.equals(o.serviceName);
            boolean bl = portNameInclude = this.portName == null ? true : this.portName.equals(o.portName);
            if (addressInclude && portTypeInclude && serviceNameInclude && portNameInclude) {
                return true;
            }
        } else if (domainExpression instanceof EndpointReference) {
            EndpointReference o = (EndpointReference)domainExpression;
            String path = null;
            if (o.getAddress() != null) {
                try {
                    Endpoint endpoint = new Endpoint(o.getAddress());
                    path = endpoint.getPath();
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }
            ServiceEndpointReference reference = new ServiceEndpointReference(path, o.getPortType(), o.getServiceName(), o.getPortName());
            return this.includes(reference);
        }
        return false;
    }

    private void load(Source source) throws PolicyException {
        try {
            DOMSource domSource = XMLSourceHelper.transformToDOMSource(source);
            if (domSource != null) {
                Element element = (Element)domSource.getNode();
                if (element == null || !ElementHelper.getTagName(element).equals(ELEMENT_QNAME)) {
                    throw new PolicyException("There is no " + ELEMENT_QNAME + " element in " + source.getSystemId());
                }
                if (element != null) {
                    Node node;
                    Element e = ElementHelper.getChildElementByTagName(element, NS_URI, "Path");
                    if (e != null && (node = e.getFirstChild()) != null && node.getNodeType() == 3) {
                        this.path = node.getNodeValue();
                    }
                    if ((e = ElementHelper.getChildElementByTagName(element, NS_URI, "PortType")) != null && (node = e.getFirstChild()) != null && node.getNodeType() == 3) {
                        this.portType = ElementHelper.getQName(e, node.getNodeValue());
                    }
                    if ((e = ElementHelper.getChildElementByTagName(element, NS_URI, "ServiceName")) != null) {
                        String portName;
                        node = e.getFirstChild();
                        if (node != null && node.getNodeType() == 3) {
                            this.serviceName = ElementHelper.getQName(e, node.getNodeValue());
                        }
                        if ((portName = ElementHelper.getAttributeNS(e, NS_URI, "portName")) != null) {
                            this.portName = portName;
                        }
                    }
                }
            }
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Source getContent() throws PolicyException {
        try {
            void e;
            DOMSource domSource = XMLSourceHelper.createDOMSource(NS_URI, "wasp:ServiceEndpointReference");
            Element element = (Element)domSource.getNode();
            Document document = element.getOwnerDocument();
            Element path = document.createElementNS(NS_URI, "wasp:Path");
            path.appendChild(document.createTextNode(this.path));
            element.appendChild(path);
            if (this.portType != null) {
                Element portType = document.createElementNS(NS_URI, "wasp:PortType");
                portType.appendChild(document.createTextNode(this.portType.getNamespaceURI() + ":" + this.portType.getLocalPart()));
                element.appendChild(portType);
            }
            if (this.serviceName != null) {
                Element serviceName = document.createElementNS(NS_URI, "wasp:ServiceName");
                serviceName.appendChild(document.createTextNode(this.serviceName.getNamespaceURI() + ":" + this.serviceName.getLocalPart()));
                if (this.portName != null) {
                    serviceName.setAttribute("PortName", this.portName);
                }
                element.appendChild(serviceName);
            }
            return e;
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
    }

    public String toString() {
        return this.path + ':' + (this.portType == null ? "" : this.portType.toString()) + ':' + (this.serviceName == null ? "" : this.serviceName.toString()) + (this.portName == null ? "" : this.portName);
    }
}

