/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.transaction;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.systinet.logging.Category;
import org.systinet.wasp.transaction.CompletionException;
import org.systinet.wasp.transaction.Terminator;

public class PropagationContext {
    private Terminator terminator;
    private final LinkedList transactionListeners = new LinkedList();
    private static final Category log = Category.getCategory("org.systinet.wasp.transaction.PropagationContext");

    public void setTerminator(Terminator terminator) {
        this.terminator = terminator;
    }

    public Terminator getTerminator() {
        return this.terminator;
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        LinkedList linkedList = this.transactionListeners;
        synchronized (linkedList) {
            this.transactionListeners.add(transactionListener);
        }
    }

    protected void callTransactionListenersBeforeCompletion() throws CompletionException {
        Iterator i = this.getListenersClone().iterator();
        while (i.hasNext()) {
            ((TransactionListener)i.next()).beforeCompletion(this);
        }
    }

    protected void callTransactionListenersAfterCompletion(int result) {
        Iterator i = this.getListenersClone().iterator();
        while (i.hasNext()) {
            try {
                ((TransactionListener)i.next()).afterCompletion(this, result);
            }
            catch (Throwable e) {
                log.error("During the transaction after-completion stage an exception has been caught (the listener may not be processed correctly)", e);
            }
        }
    }

    private final List getListenersClone() {
        LinkedList linkedList = this.transactionListeners;
        synchronized (linkedList) {
            List list = (List)this.transactionListeners.clone();
            return list;
        }
    }

    public String toString() {
        return "PropagationContext(" + System.identityHashCode(this) + ")";
    }

    public static interface TransactionListener {
        public static final int TRANSACTION_COMMITED = 0;
        public static final int TRANSACTION_ROLLBACKED = 1;

        public void beforeCompletion(PropagationContext var1) throws CompletionException;

        public void afterCompletion(PropagationContext var1, int var2);
    }
}

