/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.transaction;

import com.systinet.util.Semaphore;
import org.systinet.logging.Category;
import org.systinet.wasp.transaction.CompletionException;
import org.systinet.wasp.transaction.NoTransaction;
import org.systinet.wasp.transaction.PropagationContext;
import org.systinet.wasp.transaction.SubtransactionsUnavailable;
import org.systinet.wasp.transaction.Terminator;

public class CurrentTransaction {
    private static final ThreadLocal propagationContext = new ThreadLocal();
    private static final Semaphore maxConcurentTransactions = new Semaphore(1);
    private static boolean initialized;
    private static final Category log;

    public static final void begin() throws SubtransactionsUnavailable {
        if (CurrentTransaction.getPropagationContext() != null) {
            throw new SubtransactionsUnavailable("Can't start new transaction while in transaction");
        }
        PropagationContext newPropagationContext = new PropagationContext();
        maxConcurentTransactions.acquire();
        CurrentTransaction.resume(newPropagationContext);
    }

    public static final void commit() throws NoTransaction, CompletionException {
        PropagationContext propagationContext = CurrentTransaction.getPropagationContext();
        try {
            try {
                if (propagationContext == null) {
                    throw new NoTransaction("No active transaction");
                }
                propagationContext.callTransactionListenersBeforeCompletion();
                Terminator terminator = CurrentTransaction.getPropagationContext().getTerminator();
                if (terminator != null) {
                    terminator.commit();
                }
                CurrentTransaction.propagationContext.set(null);
                maxConcurentTransactions.release();
                propagationContext.callTransactionListenersAfterCompletion(0);
            }
            catch (NoTransaction noTransaction) {
                maxConcurentTransactions.release();
                throw noTransaction;
            }
            catch (CompletionException e) {
                maxConcurentTransactions.release();
                throw e;
            }
            catch (RuntimeException e) {
                maxConcurentTransactions.release();
                throw e;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    public static final void rollback() throws NoTransaction, CompletionException {
        PropagationContext propagationContext = CurrentTransaction.getPropagationContext();
        try {
            if (propagationContext == null) {
                throw new NoTransaction("No active transaction");
            }
            Terminator terminator = CurrentTransaction.getPropagationContext().getTerminator();
            if (terminator != null) {
                terminator.rollback();
            }
            CurrentTransaction.propagationContext.set(null);
            Object var3_2 = null;
            propagationContext.callTransactionListenersAfterCompletion(1);
            maxConcurentTransactions.release();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            propagationContext.callTransactionListenersAfterCompletion(1);
            maxConcurentTransactions.release();
            throw throwable;
        }
    }

    public static final PropagationContext suspend() {
        PropagationContext ret = (PropagationContext)propagationContext.get();
        if (ret != null) {
            propagationContext.set(null);
        }
        return ret;
    }

    public static final void resume(PropagationContext propagationContext) throws SubtransactionsUnavailable {
        if (CurrentTransaction.getPropagationContext() != null) {
            throw new SubtransactionsUnavailable("Can't resume transaction while in transaction");
        }
        CurrentTransaction.propagationContext.set(propagationContext);
    }

    public static final PropagationContext getPropagationContext() {
        return (PropagationContext)propagationContext.get();
    }

    public static final synchronized void setMaximumTransactions(int maximumTransations) {
        maxConcurentTransactions.setMaxPermits(maximumTransations);
        initialized = true;
    }

    public static final synchronized int getMaximumTransactions() {
        int ret = maxConcurentTransactions.getMaxPermits();
        if (!initialized && ret == 1) {
            return Integer.MAX_VALUE;
        }
        return ret;
    }

    static {
        log = Category.getCategory("org.systinet.wasp.transaction.CurrentTransaction");
    }
}

