/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.soap.bc;

import org.idoox.transport.Connection;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xmlrpc.Message;
import org.systinet.wasp.soap.WaspMessageFactory;
import org.systinet.wasp.soap.WaspSOAPMessage;
import org.systinet.wasp.soap.bc.IMessageConvertor;

public class MessageConvertor {
    public static final String DEFAULT_FACTORY = "com.systinet.saaj.soap.bc.MessageConvertorImpl";
    private static IMessageConvertor impl = null;

    private MessageConvertor() {
    }

    private static final IMessageConvertor getConvertor() {
        if (impl == null) {
            impl = MessageConvertor.newInstance();
        }
        return impl;
    }

    private static final IMessageConvertor newInstance() {
        try {
            return (IMessageConvertor)Class.forName(DEFAULT_FACTORY).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public static final Message getMessage(WaspSOAPMessage soapMessage) {
        return MessageConvertor.getConvertor().getMessage(soapMessage);
    }

    public static final Message convertSOAPMessage(WaspSOAPMessage soapMessage, boolean isInput, boolean needsBody) {
        return MessageConvertor.getConvertor().convertSOAPMessage(soapMessage, isInput, needsBody);
    }

    public static final WaspSOAPMessage convertMessage(Message message) {
        return MessageConvertor.getConvertor().convertMessage(message);
    }

    public static final Message createMessage(String protocol, WaspMessageFactory messageFactory, Connection connection) {
        return MessageConvertor.getConvertor().createMessage(protocol, messageFactory, connection);
    }
}

