/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.soap;

import java.io.IOException;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerWrapper;

public class FirstElementSkippingTokenizer
extends TokenizerWrapper {
    private int depth = 0;
    private boolean endReached = false;
    private boolean skipContent;
    private boolean endSignalized = false;
    private boolean startSkipped = false;
    private boolean omitNamespaceDecls;
    private DeclaredPrefixesStack dps;

    public FirstElementSkippingTokenizer(Tokenizer tokenizer) {
        this(tokenizer, false, false);
    }

    public FirstElementSkippingTokenizer(Tokenizer tokenizer, boolean skipContent, boolean omitNamespaceDecls) {
        super(tokenizer);
        this.skipContent = skipContent;
        this.omitNamespaceDecls = omitNamespaceDecls;
        this.dps = null;
    }

    public byte next() throws TokenizerException, IOException {
        if (this.endSignalized) {
            throw new TokenizerException("Already at the end of the document!");
        }
        byte next = super.next();
        switch (next) {
            case 2: {
                if (!this.startSkipped) {
                    this.startSkipped = true;
                    next = this.skipToken();
                    if (next == 2) {
                        ++this.depth;
                        break;
                    }
                    if (next != 3) break;
                    --this.depth;
                    this.endSignalized = true;
                    return 1;
                }
                if (this.endReached) {
                    this.endReached = false;
                }
                ++this.depth;
                break;
            }
            case 3: {
                --this.depth;
                if (this.depth == 0) {
                    this.endReached = true;
                    break;
                }
                if (this.depth != -1) break;
                this.endSignalized = true;
                return 1;
            }
            case 4: {
                if (!this.skipContent || this.depth != 0) break;
                return this.next();
            }
        }
        return next;
    }

    protected TokenizerWrapper.TokenizerState getCurrentState() {
        try {
            if (!this.startSkipped) {
                this.startSkipped = true;
                this.initDPS();
                byte next = this.skipFirstToken();
                if (next == 3) {
                    Token currentToken = new Token();
                    this.endSignalized = true;
                    currentToken.type = 1;
                    return new TokenizerWrapper.DefaultTokenizerState(currentToken);
                }
            }
        }
        catch (TokenizerException e) {
            throw new RuntimeWrappedException("Unable to skip first token!", e);
        }
        catch (IOException e) {
            throw new RuntimeWrappedException("Unable to skip first token!", e);
        }
        return super.getCurrentState();
    }

    private void initDPS() throws TokenizerException, IOException {
        if (!this.omitNamespaceDecls) {
            this.dps = new DeclaredPrefixesStack();
            this.getTokenizer().pushNewlyDeclaredPrefixes(this.dps);
        }
    }

    private byte skipFirstToken() throws TokenizerException, IOException {
        byte next = this.skipToken();
        if (next == 2) {
            ++this.depth;
        }
        return next;
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        try {
            int oldUse = prefixes.used;
            if (!this.startSkipped) {
                this.startSkipped = true;
                this.initDPS();
                this.skipFirstToken();
            }
            this.getTokenizer().pushNewlyDeclaredPrefixes(prefixes);
            if (this.depth == 1) {
                this.copyDPS(this.dps, prefixes);
            }
            return prefixes.used - oldUse;
        }
        catch (TokenizerException e) {
            throw new RuntimeWrappedException(e);
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    private void copyDPS(DeclaredPrefixesStack source, DeclaredPrefixesStack destination) {
        if (source == null || source.used == 0) {
            return;
        }
        int newSize = destination.used + source.used;
        if (newSize == 0) {
            return;
        }
        destination.enlarge(source.used);
        int j = destination.used;
        int i = 0;
        while (i < source.used) {
            String prefix = source.prefixes[i];
            String prefixValue = source.prefixValues[i];
            String previousPrefixValue = source.previousPrefixValues[i];
            int prefixDestPos = this.findPrefix(destination, prefix);
            if (prefixDestPos < 0) {
                destination.prefixes[j] = prefix;
                destination.prefixValues[j] = prefixValue;
                destination.previousPrefixValues[j] = previousPrefixValue;
                ++j;
            }
            ++i;
        }
        destination.used = j;
    }

    private int findPrefix(DeclaredPrefixesStack destination, String prefix) {
        if (destination == null || destination.used == 0) {
            return -1;
        }
        int i = 0;
        while (i < destination.prefixes.length) {
            String destPrefix = destination.prefixes[i];
            if (prefix.equals(destPrefix)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private byte skipToken() throws TokenizerException, IOException {
        byte next;
        Tokenizer tokenizer = this.getTokenizer();
        if (this.skipContent) {
            while ((next = tokenizer.next()) == 4) {
            }
        } else {
            next = tokenizer.next();
        }
        return next;
    }
}

