/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.sequence;

import java.io.Serializable;
import java.util.Date;
import org.idoox.wasp.Context;
import org.systinet.wasp.sequence.ISequence;
import org.systinet.wasp.sequence.ISequenceRegistry;
import org.systinet.wasp.sequence.SequenceException;
import org.systinet.wasp.sequence.SequenceListener;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Processing;

public abstract class Sequence {
    private static final Sequence[] NO_SEQUENCE = new Sequence[0];
    static /* synthetic */ Class class$org$systinet$wasp$sequence$ISequenceRegistry;

    protected Sequence() {
    }

    public static Sequence createOutputSequence(Processing processing) throws SequenceException {
        return Sequence.createOutputSequence(null, true, processing);
    }

    public static Sequence createOutputSequence(String prefix, boolean generateSuffix, Processing processing) throws SequenceException {
        return ((ISequenceRegistry)Context.getInstance(class$org$systinet$wasp$sequence$ISequenceRegistry == null ? (class$org$systinet$wasp$sequence$ISequenceRegistry = Sequence.class$("org.systinet.wasp.sequence.ISequenceRegistry")) : class$org$systinet$wasp$sequence$ISequenceRegistry)).createSequence(prefix, generateSuffix, processing, true);
    }

    public static Sequence getOutputSequence(String id, boolean matchPrefix, Processing processing) throws SequenceException {
        return ((ISequenceRegistry)Context.getInstance(class$org$systinet$wasp$sequence$ISequenceRegistry == null ? (class$org$systinet$wasp$sequence$ISequenceRegistry = Sequence.class$("org.systinet.wasp.sequence.ISequenceRegistry")) : class$org$systinet$wasp$sequence$ISequenceRegistry)).getSequence(id, matchPrefix, processing, true);
    }

    public static Sequence[] getOutputSequences(String prefix, Processing processing) throws SequenceException {
        return ((ISequenceRegistry)Context.getInstance(class$org$systinet$wasp$sequence$ISequenceRegistry == null ? (class$org$systinet$wasp$sequence$ISequenceRegistry = Sequence.class$("org.systinet.wasp.sequence.ISequenceRegistry")) : class$org$systinet$wasp$sequence$ISequenceRegistry)).getOutputSequences(prefix, processing);
    }

    public static Sequence getActiveOutputSequence() throws IllegalStateException {
        CallContext callContext = Current.getCallContext();
        if (callContext == null) {
            throw new IllegalStateException("Call context is not known, use service client call context instead.");
        }
        ThreadLocal tl = (ThreadLocal)callContext.getContextData().get("sequence.output");
        return tl != null ? (Sequence)tl.get() : null;
    }

    public static Sequence getActiveInputSequence() throws IllegalStateException {
        CallContext callContext = Current.getCallContext();
        if (callContext == null) {
            throw new IllegalStateException("Call context is not known, use service client call context instead.");
        }
        return (Sequence)callContext.getContextData().get("sequence.input");
    }

    public abstract String getID();

    public abstract boolean isOutput();

    public abstract void setActive(boolean var1) throws SequenceException;

    public abstract boolean isActive();

    public abstract Date getExpires();

    public abstract void setExpires(Date var1) throws SequenceException;

    public abstract State getState();

    public abstract void abort() throws SequenceException;

    public abstract boolean isExpired();

    public abstract long getLength();

    public abstract long getCurrentLength();

    public abstract void setLength(long var1) throws SequenceException;

    public abstract void setLastMessage() throws SequenceException;

    public abstract MessageState getMessageState(long var1) throws SequenceException;

    public abstract long getCurrentMessageNumber();

    public abstract void setExplicitConfirmation(boolean var1) throws SequenceException;

    public abstract boolean isExplicitConfirmation();

    public abstract void confirmCurrentMessage() throws SequenceException;

    public abstract void confirmMessage(long var1) throws SequenceException;

    public static void addSequenceListener(SequenceListener listener, Processing processing) {
        ((ISequenceRegistry)Context.getInstance(class$org$systinet$wasp$sequence$ISequenceRegistry == null ? (class$org$systinet$wasp$sequence$ISequenceRegistry = Sequence.class$("org.systinet.wasp.sequence.ISequenceRegistry")) : class$org$systinet$wasp$sequence$ISequenceRegistry)).addSequenceListener(listener, processing);
    }

    public static void removeSequenceListener(SequenceListener listener, Processing processing) {
        ((ISequenceRegistry)Context.getInstance(class$org$systinet$wasp$sequence$ISequenceRegistry == null ? (class$org$systinet$wasp$sequence$ISequenceRegistry = Sequence.class$("org.systinet.wasp.sequence.ISequenceRegistry")) : class$org$systinet$wasp$sequence$ISequenceRegistry)).removeSequenceListener(listener, processing);
    }

    public static Sequence loadOutputSequence(String id, boolean matchPrefix, Processing processing) throws SequenceException {
        ISequenceRegistry registry = (ISequenceRegistry)Context.getInstance(class$org$systinet$wasp$sequence$ISequenceRegistry == null ? (class$org$systinet$wasp$sequence$ISequenceRegistry = Sequence.class$("org.systinet.wasp.sequence.ISequenceRegistry")) : class$org$systinet$wasp$sequence$ISequenceRegistry);
        ISequence loadedSequence = null;
        if (matchPrefix) {
            ISequence[] sequences = registry.getOutputSequences(id, processing);
            int i = 0;
            while (i < sequences.length) {
                ISequence sequence = sequences[i];
                if (sequence.getState() == State.OPEN || sequence.getState() == State.DELIVERED) {
                    loadedSequence = sequence;
                    break;
                }
                ++i;
            }
        } else {
            ISequence sequence = registry.getSequence(id, matchPrefix, processing, true);
            if (sequence != null && sequence.getState() == State.OPEN || sequence.getState() == State.DELIVERED) {
                loadedSequence = sequence;
            }
        }
        return loadedSequence;
    }

    public static Sequence[] loadOutputSequences(String prefix, Processing processing) throws SequenceException {
        ISequenceRegistry registry = (ISequenceRegistry)Context.getInstance(class$org$systinet$wasp$sequence$ISequenceRegistry == null ? (class$org$systinet$wasp$sequence$ISequenceRegistry = Sequence.class$("org.systinet.wasp.sequence.ISequenceRegistry")) : class$org$systinet$wasp$sequence$ISequenceRegistry);
        ISequence[] sequences = registry.getOutputSequences(prefix, processing);
        int count = 0;
        int i = 0;
        while (i < sequences.length) {
            ISequence sequence = sequences[i];
            if (sequence.getState() == State.OPEN || sequence.getState() == State.DELIVERED) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            Sequence[] loadedSequences = new Sequence[count];
            int i2 = 0;
            int j = 0;
            while (i2 < sequences.length) {
                ISequence sequence = sequences[i2];
                if (sequence.getState() == State.OPEN || sequence.getState() == State.DELIVERED) {
                    loadedSequences[j++] = sequence;
                }
                ++i2;
            }
            return loadedSequences;
        }
        return NO_SEQUENCE;
    }

    public abstract void setPersistent(boolean var1);

    public abstract boolean isPersistent();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MessageState {
        private int value;
        public static final int _NOT_PRESENT = 0;
        public static final int _NOT_DELIVERED = 1;
        public static final int _DELIVERED = 2;
        public static final MessageState NOT_PRESENT = new MessageState(0);
        public static final MessageState NOT_DELIVERED = new MessageState(1);
        public static final MessageState DELIVERED = new MessageState(2);
        private static final String[] NAMES = new String[]{"NOT_PRESENT", "NOT_DELIVERED", "DELIVERED"};
        private static final MessageState[] STATES = new MessageState[]{NOT_PRESENT, NOT_DELIVERED, DELIVERED};

        protected MessageState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MessageState fromValue(int value) {
            return STATES[value];
        }

        public String toString() {
            return NAMES[this.value];
        }
    }

    public static class State
    implements Serializable {
        private int value;
        public static final int _OPEN = 0;
        public static final int _DELIVERED = 1;
        public static final int _COMPLETE = 2;
        public static final int _BROKEN = 3;
        public static final int _DESTROYED = 4;
        public static final State OPEN = new State(0);
        public static final State DELIVERED = new State(1);
        public static final State COMPLETE = new State(2);
        public static final State BROKEN = new State(3);
        public static final State DESTROYED = new State(4);
        private static final String[] NAMES = new String[]{"OPEN", "DELIVERED", "COMPLETE", "BROKEN", "DESTROYED"};
        private static final State[] STATES = new State[]{OPEN, DELIVERED, COMPLETE, BROKEN, DESTROYED};
        private static final long serialVersionUID = 497140064102499034L;

        protected State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static State fromValue(int value) {
            return STATES[value];
        }

        public String toString() {
            return NAMES[this.value];
        }

        protected State() {
        }

        private Object readResolve() {
            return State.fromValue(this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof State)) {
                return false;
            }
            State state = (State)o;
            return this.value == state.value;
        }

        public int hashCode() {
            return this.value;
        }
    }
}

