/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.sequence;

import java.util.Map;
import org.systinet.wasp.sequence.Sequence;
import org.systinet.wasp.sequence.SequenceException;
import org.systinet.wasp.sequence.SequenceProviderData;
import org.systinet.wasp.transaction.LockableResource;
import org.systinet.wasp.webservice.Processing;

public abstract class ISequence
extends Sequence
implements LockableResource {
    public static final long NO_PROCESSING_ID = -1L;

    public abstract String getProviderName();

    public abstract void setProviderName(String var1) throws SequenceException;

    public abstract Processing getProcessing();

    public abstract SequenceProviderData getProviderData();

    public abstract void setState(Sequence.State var1) throws SequenceException;

    public abstract void expire() throws SequenceException;

    public abstract boolean isLastMessage();

    public abstract void setCurrentMessageNumber(long var1) throws SequenceException;

    public abstract void setCurrentLength(long var1) throws SequenceException;

    public abstract void release() throws SequenceException;

    public static ISequence getActiveOutputSequence(Map contextData) {
        ThreadLocal tl = (ThreadLocal)contextData.get("sequence.output");
        return tl != null ? (ISequence)tl.get() : null;
    }

    public static void setActiveOutputSequence(ISequence sequence, Map contextData) {
        ThreadLocal<ISequence> tl = (ThreadLocal<ISequence>)contextData.get("sequence.output");
        if (tl == null) {
            tl = new ThreadLocal<ISequence>();
            contextData.put("sequence.output", tl);
        }
        tl.set(sequence);
    }

    public abstract void lock();

    public abstract void unlock();

    public abstract String getEndpointPath();

    public abstract long getProcessingId();

    public abstract void rollback();

    public abstract void commit();

    public abstract void begin();
}

