/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.rpc.handler;

import com.idoox.util.HierarchicalMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.systinet.wasp.webservice.CallContext;

public abstract class ContextHolder
implements Externalizable {
    static final long serialVersionUID = -3765444158545225898L;
    Map messageProperties;
    Map callContextData;

    public ContextHolder() {
    }

    protected ContextHolder(CallContext callContext, Map messageProperties, boolean clone) {
        if (clone) {
            this.callContextData = new HashMap(((HierarchicalMap)callContext.getContextData()).getOwnMap());
            this.messageProperties = new HashMap(messageProperties);
        } else {
            this.callContextData = ((HierarchicalMap)callContext.getContextData()).getOwnMap();
            this.messageProperties = messageProperties;
        }
    }

    protected ContextHolder(ContextHolder holder, boolean clone) {
        if (clone) {
            this.callContextData = new HashMap(holder.callContextData);
            this.messageProperties = new HashMap(holder.messageProperties);
        } else {
            this.callContextData = holder.callContextData;
            this.messageProperties = holder.messageProperties;
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.callContextData = (Map)in.readObject();
        this.messageProperties = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(ContextHolder.createSerializableMap(this.callContextData));
        out.writeObject(ContextHolder.createSerializableMap(this.messageProperties));
    }

    public Map getCallContextData() {
        return this.callContextData;
    }

    public Map getMessageProperties() {
        return this.messageProperties;
    }

    private static final HashMap createSerializableMap(Map source) {
        HashMap ret = new HashMap();
        Iterator i = source.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if ("wasp.transport.servlet".equals(key) || "wasp.transport.servlet_request".equals(key) || "wasp.transport.servlet_response".equals(key) || key == null || value == null || !(key instanceof Serializable) || !(value instanceof Serializable) || value instanceof Object[] && (!(value instanceof Object[]) || !(value instanceof Serializable[])) || Proxy.isProxyClass(value.getClass()) || value instanceof Map) continue;
            ret.put(key, entry.getValue());
        }
        return ret;
    }
}

