/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.policy.assertion;

import com.idoox.util.ElementHelper;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.systinet.wasp.policy.PolicyAssertion;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.wasp.policy.PolicyUsage;
import org.systinet.xml.XMLSourceHelper;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpecVersionAssertion
extends PolicyAssertion {
    private static final QName ELEMENT_QNAME = new QName("http://schemas.xmlsoap.org/ws/2002/07/utility", "SpecVersion");
    private static final String ATTRIBUTE_URI_NAME = "URI";
    private static final String ELEMENT_TAGNAME = "wsu:" + ELEMENT_QNAME.getLocalPart();
    private String uri;

    public SpecVersionAssertion(Source content) throws PolicyException {
        this.load(content);
    }

    public SpecVersionAssertion(String uri, PolicyUsage usage) {
        this.setUsage(usage);
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    private void load(Source content) throws PolicyException {
        try {
            DOMSource domSource = XMLSourceHelper.transformToDOMSource(content);
            Element element = (Element)domSource.getNode();
            if (element == null || !ElementHelper.getTagName(element).equals(ELEMENT_QNAME)) {
                throw new PolicyException("There is no " + ELEMENT_QNAME + " element in " + content.getSystemId());
            }
            this.uri = element.getAttribute(ATTRIBUTE_URI_NAME);
            this.readStandardAttributes(domSource);
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
        catch (DOMException e) {
            throw new PolicyException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Source getContent() throws PolicyException {
        try {
            void e;
            DOMSource domSource = XMLSourceHelper.createDOMSource(ELEMENT_QNAME.getNamespaceURI(), ELEMENT_TAGNAME);
            Element element = (Element)domSource.getNode();
            Document document = element.getOwnerDocument();
            element.setAttribute(ATTRIBUTE_URI_NAME, this.uri);
            this.writeStandardAttributes(domSource);
            return e;
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
        catch (DOMException e) {
            throw new PolicyException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpecVersionAssertion)) {
            return false;
        }
        SpecVersionAssertion specVersionAssertion = (SpecVersionAssertion)o;
        return this.uri.equals(specVersionAssertion.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

