/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.policy;

import com.idoox.debug.Category;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.idoox.wasp.Context;
import org.systinet.wasp.policy.IPolicyManager;
import org.systinet.wasp.policy.PolicyElement;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.xml.XMLSourceHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class PolicyCompositor
extends PolicyElement {
    private static final Category cat = Category.getCategory("org.systinet.wasp.policy.PolicyCompositor");
    private String id;
    private HashMap elements = new HashMap();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void add(PolicyElement element) throws PolicyException {
        if (element.getParentElement() != null && element.getParentElement() != this) {
            throw new PolicyException("Added policy element is already in another compositor.");
        }
        PolicyElement e = (PolicyElement)this.elements.get(element);
        if (e == null) {
            this.elements.put(element, element);
        } else {
            if (element.getPreference() >= e.getPreference()) {
                this.elements.put(element, element);
            }
            if (element.getPreference() == e.getPreference()) {
                cat.warn("Added policy element: " + element.getClass().getName() + ", which already exists in compositor with the same preference: " + element.getPreference());
            }
        }
        element.setParentElement(this);
    }

    public void remove(PolicyElement element) {
        this.elements.remove(element);
        try {
            element.setParentElement(null);
        }
        catch (PolicyException policyException) {
            // empty catch block
        }
    }

    public PolicyElement[] getElements() {
        return this.elements.values().toArray(new PolicyElement[0]);
    }

    void load(Source source) throws PolicyException {
        try {
            DOMSource domSource = XMLSourceHelper.transformToDOMSource(source);
            this.readStandardAttributes(domSource);
            this.getPolicyManager().loadPolicyCompositor(domSource, this);
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
    }

    void write(DOMSource domSource) throws PolicyException {
        try {
            this.writeStandardAttributes(domSource);
            Element element = (Element)domSource.getNode();
            if (this.id != null) {
                element.setAttributeNS("http://schemas.xmlsoap.org/ws/2002/07/utility", "wsu:Id", this.id);
                element.setAttribute("xmlns:wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
            }
            Iterator iterator = this.elements.values().iterator();
            while (iterator.hasNext()) {
                PolicyElement policyElement = (PolicyElement)iterator.next();
                DOMSource childDomSource = XMLSourceHelper.transformToDOMSource(policyElement.getContent());
                if (childDomSource.getNode().getOwnerDocument() != element.getOwnerDocument()) {
                    Node imported = element.getOwnerDocument().importNode(childDomSource.getNode(), true);
                    element.appendChild(imported);
                    continue;
                }
                element.appendChild(childDomSource.getNode());
            }
        }
        catch (TransformerException e) {
            throw new PolicyException(e);
        }
    }

    public abstract Source getContent() throws PolicyException;

    private IPolicyManager getPolicyManager() {
        return (IPolicyManager)Context.getInstance("org.systinet.wasp.policy.PolicyManager");
    }
}

