/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.addressing;

import com.idoox.debug.Category;
import com.idoox.util.ElementHelper;
import java.io.Serializable;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.idoox.xml.TokenizerSource;
import org.systinet.wasp.addressing.Constants;
import org.systinet.wasp.addressing.ReferenceProperties;
import org.systinet.wasp.policy.DefaultDomainExpression;
import org.systinet.wasp.policy.DomainExpression;
import org.systinet.wasp.policy.EffectivePolicy;
import org.systinet.wasp.policy.PolicyException;
import org.systinet.wasp.policy.PolicyManager;
import org.systinet.wasp.policy.PolicyUsage;
import org.systinet.wasp.policy.assertion.SpecVersionAssertion;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.xml.XMLSourceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EndpointReference
implements DomainExpression,
Serializable {
    private static final Category log = Category.getCategory((class$org$systinet$wasp$addressing$EndpointReference == null ? (class$org$systinet$wasp$addressing$EndpointReference = EndpointReference.class$("org.systinet.wasp.addressing.EndpointReference")) : class$org$systinet$wasp$addressing$EndpointReference).getName());
    public static final String ANONYMOUS = "http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous";
    private static final String LOCAL_NAME = "EndpointReference";
    private static final QName ELEMENT_QNAME_2003_3 = new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "EndpointReference");
    private static final QName ELEMENT_QNAME_2004_3 = new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "EndpointReference");
    private static final QName ELEMENT_QNAME_2004_8 = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "EndpointReference");
    private static final QName[] ELEMENT_QNAMES = new QName[]{ELEMENT_QNAME_2004_8, ELEMENT_QNAME_2004_3, ELEMENT_QNAME_2003_3};
    private boolean isAnonymous;
    private boolean hashComputed = false;
    private int cachedHashCode;
    private String address;
    private QName portType;
    private QName serviceName;
    private String portName;
    private ReferenceProperties referenceProperties;
    static /* synthetic */ Class class$org$systinet$wasp$addressing$EndpointReference;

    public EndpointReference() {
        this((String)null);
    }

    public EndpointReference(String address) {
        this(address, null, null, null);
    }

    public EndpointReference(String address, QName portType, QName serviceName, String portName) {
        if (address == null) {
            this.address = ANONYMOUS;
            this.isAnonymous = true;
        } else {
            this.address = address;
            this.isAnonymous = ANONYMOUS.equals(this.address);
        }
        this.portType = portType;
        this.serviceName = serviceName;
        this.portName = portName;
    }

    public EndpointReference(ServiceClient client) throws LookupException {
        this(client.getServiceURL(), null, client.getWSDLServiceName(), client.getWSDLPortName());
    }

    public EndpointReference(Source source) throws PolicyException {
        this.load(source);
        if (this.address == null) {
            this.address = ANONYMOUS;
        }
        this.isAnonymous = this.address.equals(ANONYMOUS);
    }

    public String getAddress() {
        return this.address;
    }

    public QName getPortType() {
        return this.portType;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }

    public boolean isAnonymous() {
        return this.isAnonymous;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        boolean bl;
        if (!(obj instanceof EndpointReference)) {
            return false;
        }
        EndpointReference o = (EndpointReference)obj;
        if (o == this) return true;
        if (this.address == null) {
            if (o.address != null) return false;
            bl = true;
        } else {
            bl = this.address.equals(o.address);
        }
        if (!bl) return false;
        if (this.referenceProperties == null) {
            if (o.referenceProperties != null) return false;
            return true;
        }
        boolean bl2 = this.referenceProperties.equals(o.referenceProperties);
        if (!bl2) return false;
        return true;
    }

    public int hashCode() {
        if (!this.hashComputed) {
            this.cachedHashCode = (this.address == null ? 0 : this.address.hashCode()) ^ (this.referenceProperties == null ? 0 : this.referenceProperties.hashCode());
            this.hashComputed = true;
        }
        return this.cachedHashCode;
    }

    public boolean includes(DomainExpression domainExpression) {
        if (domainExpression == null) {
            return false;
        }
        if (domainExpression instanceof EndpointReference) {
            boolean referencePropertiesInclude;
            EndpointReference o = (EndpointReference)domainExpression;
            if (this.equals(o)) {
                return true;
            }
            boolean addressInclude = this.address == null ? true : this.address.equals(o.address);
            boolean bl = referencePropertiesInclude = this.referenceProperties == null ? true : this.referenceProperties.equals(o.referenceProperties);
            if (addressInclude && referencePropertiesInclude) {
                return true;
            }
        }
        return false;
    }

    private void load(Source source) throws PolicyException {
        block13: {
            try {
                Node node;
                DOMSource domSource = XMLSourceHelper.transformToDOMSource(source);
                if (domSource == null) break block13;
                Element element = (Element)domSource.getNode();
                if (element == null) {
                    throw new PolicyException("There is no EndpointReference element in " + source.getSystemId());
                }
                String ns_uri = null;
                int i = 0;
                while (i < ELEMENT_QNAMES.length) {
                    if (ElementHelper.getTagName(element).equals(ELEMENT_QNAMES[i])) {
                        ns_uri = ELEMENT_QNAMES[i].getNamespaceURI();
                        break;
                    }
                    ++i;
                }
                if (ns_uri == null) {
                    throw new PolicyException("There is no EndpointReference element in supported namespaces in " + source.getSystemId());
                }
                Element e = ElementHelper.getChildElementByTagName(element, ns_uri, "Address");
                if (e != null && (node = e.getFirstChild()) != null && node.getNodeType() == 3) {
                    this.address = node.getNodeValue();
                    this.isAnonymous = Constants.WSA_TO_ADDRESS_ANONYMOUS_MAPPING.get(ns_uri).equals(this.address);
                }
                if ((e = ElementHelper.getChildElementByTagName(element, ns_uri, "PortType")) != null && (node = e.getFirstChild()) != null && node.getNodeType() == 3) {
                    this.portType = ElementHelper.getQName(e, node.getNodeValue());
                }
                if ((e = ElementHelper.getChildElementByTagName(element, ns_uri, "ServiceName")) != null) {
                    String portName;
                    node = e.getFirstChild();
                    if (node != null && node.getNodeType() == 3) {
                        this.serviceName = ElementHelper.getQName(e, node.getNodeValue());
                    }
                    if ((portName = ElementHelper.getAttributeNS(e, ns_uri, "portName")) != null) {
                        this.portName = portName;
                    }
                }
                if ((e = ElementHelper.getChildElementByTagName(element, "ReferenceProperties")) == null) break block13;
                try {
                    this.referenceProperties = this.getReferenceProperties();
                }
                catch (SOAPException e1) {
                    new PolicyException("Cannot load ReferenceProperties", e1);
                }
                TokenizerSource tokenizerSource = new TokenizerSource();
                tokenizerSource.setNode(e);
                this.referenceProperties.setContent(tokenizerSource);
            }
            catch (TransformerException e) {
                throw new PolicyException(e);
            }
        }
    }

    public Source getContent() throws PolicyException {
        try {
            String useAddressingURI = EndpointReference.computeAddressingURI();
            DOMSource domSource = XMLSourceHelper.createDOMSource(useAddressingURI, "wsa:EndpointReference");
            Element element = (Element)domSource.getNode();
            Document document = element.getOwnerDocument();
            Element path = document.createElementNS(useAddressingURI, "wsa:Address");
            path.appendChild(document.createTextNode(this.address));
            element.appendChild(path);
            if (this.portType != null) {
                Element portType = document.createElementNS(useAddressingURI, "wsa:PortType");
                portType.appendChild(document.createTextNode(this.portType.getNamespaceURI() + ":" + this.portType.getLocalPart()));
                element.appendChild(portType);
            }
            if (this.serviceName != null) {
                Element serviceName = document.createElementNS(useAddressingURI, "wsa:ServiceName");
                serviceName.appendChild(document.createTextNode(this.serviceName.getNamespaceURI() + ":" + this.serviceName.getLocalPart()));
                if (this.portName != null) {
                    serviceName.setAttribute("PortName", this.portName);
                }
                element.appendChild(serviceName);
            }
            if (this.referenceProperties != null) {
                Node rfNode = ((TokenizerSource)this.referenceProperties.getContent()).getNode();
                if (rfNode instanceof Document) {
                    rfNode = rfNode.getFirstChild();
                }
                Node importedNode = document.importNode(rfNode, true);
                element.appendChild(importedNode);
            }
            return domSource;
        }
        catch (ParserConfigurationException e) {
            throw new PolicyException(e);
        }
    }

    private static String computeAddressingURI() throws PolicyException {
        EffectivePolicy effectivePolicy = PolicyManager.getEffectivePolicy(new DefaultDomainExpression());
        int maxPreference = -1;
        SpecVersionAssertion wsa = null;
        int i = 0;
        while (i < Constants.SUPPORTED_WSA.length) {
            SpecVersionAssertion wsaTemp = (SpecVersionAssertion)effectivePolicy.getAssertion(new SpecVersionAssertion(Constants.SUPPORTED_WSA[i], null));
            if (wsaTemp != null && !wsaTemp.getUsage().equals(PolicyUsage.REJECTED) && wsaTemp.getPreference() > maxPreference) {
                maxPreference = wsaTemp.getPreference();
                wsa = wsaTemp;
            }
            ++i;
        }
        if (wsa == null) {
            throw new PolicyException("No supported WS-Addressing version found in effective policy");
        }
        String useAddressingURI = wsa.getURI();
        return useAddressingURI;
    }

    public String toString() {
        return this.address + ':' + (this.portType == null ? "" : this.portType.toString()) + ':' + (this.serviceName == null ? "" : this.serviceName.toString()) + (this.portName == null ? "" : this.portName);
    }

    public ReferenceProperties getReferenceProperties() throws SOAPException {
        if (this.referenceProperties == null) {
            this.referenceProperties = new ReferenceProperties();
        }
        return this.referenceProperties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

