/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.wasp.addressing;

import java.util.Map;
import org.systinet.wasp.addressing.AddressingHeaders;
import org.systinet.wasp.addressing.EndpointReference;

public class AddressingHeadersHelper {
    private static final String I_HAVE_SET_OMIH = "omih.set.by.addressingheadershelper";
    private static final ToResolver responseToResolver = new ToResolver(){

        public EndpointReference getTo(AddressingHeaders imih) {
            EndpointReference to = imih.replyTo;
            if (to == null) {
                to = imih.from;
            }
            if (to == null) {
                to = new EndpointReference("http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous");
            }
            return to;
        }
    };
    private static final ToResolver faultToResolver = new ToResolver(){

        public EndpointReference getTo(AddressingHeaders imih) {
            EndpointReference to = imih.faultTo;
            if (to == null) {
                to = imih.replyTo;
            }
            if (to == null) {
                to = imih.from;
            }
            if (to == null) {
                to = new EndpointReference("http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous");
            }
            return to;
        }
    };
    private static final ToResolver controlToResolver = new ToResolver(){

        public EndpointReference getTo(AddressingHeaders imih) {
            EndpointReference to = imih.from;
            if (to == null) {
                to = new EndpointReference("http://schemas.xmlsoap.org/ws/2003/03/addressing/role/anonymous");
            }
            return to;
        }
    };

    public static EndpointReference getReplyAddress(AddressingHeaders mih) {
        if (mih.replyTo != null && !mih.replyTo.isAnonymous()) {
            return mih.replyTo;
        }
        if (mih.replyTo == null && mih.from != null && !mih.from.isAnonymous()) {
            return mih.from;
        }
        return null;
    }

    public static EndpointReference getFaultAddress(AddressingHeaders mih) {
        if (mih.faultTo != null && !mih.faultTo.isAnonymous()) {
            return mih.faultTo;
        }
        if (mih.faultTo == null && mih.from != null && !mih.from.isAnonymous()) {
            return mih.from;
        }
        return null;
    }

    public static final void createAndSetupOMIH(EndpointReference to, EndpointReference from, String messageId, Map callContextData) {
        AddressingHeaders omih = (AddressingHeaders)callContextData.get("addressing.output");
        callContextData.put("addressing.output", AddressingHeadersHelper.createAndSetupOMIH(to, from, messageId, omih, callContextData));
    }

    private static final AddressingHeaders createAndSetupOMIH(EndpointReference to, EndpointReference from, String messageId, AddressingHeaders omih, Map callContextData) {
        boolean isOneway;
        boolean omihWasNull = false;
        if (omih == null) {
            omih = new AddressingHeaders(to);
            omihWasNull = true;
        }
        if (omih.messageID == null) {
            omih.messageID = messageId;
        }
        boolean bl = isOneway = callContextData.get("oneway.method") != null;
        if (!(isOneway && omihWasNull || omih.replyTo != null)) {
            omih.replyTo = from;
        }
        if (omih.faultTo == null) {
            omih.faultTo = from;
        }
        if (omih.from == null) {
            omih.from = from;
        }
        return omih;
    }

    public static final void createAndSetupResponseOMIHfromIMIH(Map callContextData) {
        AddressingHeadersHelper.createAndSetupOMIHfromIMIHTemplate(responseToResolver, callContextData);
    }

    public static final void createAndSetupFaultOMIHfromIMIH(Map callContextData) {
        AddressingHeadersHelper.createAndSetupOMIHfromIMIHTemplate(faultToResolver, callContextData);
    }

    public static final void createAndSetupControlOMIHfromIMIH(Map callContextData) {
        AddressingHeadersHelper.createAndSetupOMIHfromIMIHTemplate(controlToResolver, callContextData);
    }

    private static final void createAndSetupOMIHfromIMIHTemplate(ToResolver toResolver, Map callContextData) {
        AddressingHeaders imih = (AddressingHeaders)callContextData.get("addressing.input");
        AddressingHeaders omih = (AddressingHeaders)callContextData.get("addressing.output");
        if (imih == null || imih.from == null && imih.replyTo == null && imih.faultTo == null) {
            return;
        }
        EndpointReference to = toResolver.getTo(imih);
        if (omih == null) {
            callContextData.put(I_HAVE_SET_OMIH, I_HAVE_SET_OMIH);
        } else if (callContextData.containsKey(I_HAVE_SET_OMIH) && !to.getAddress().equals(omih.to.getAddress())) {
            omih = null;
        }
        omih = AddressingHeadersHelper.createAndSetupOMIH(to, imih.to, AddressingHeaders.generateUniqueMessageID(), omih, callContextData);
        if (imih.messageID != null) {
            omih.setRelatedMessageID(imih.messageID, null);
        }
        callContextData.put("addressing.output", AddressingHeadersHelper.createAndSetupOMIH(to, imih.to, AddressingHeaders.generateUniqueMessageID(), omih, callContextData));
    }

    private static interface ToResolver {
        public EndpointReference getTo(AddressingHeaders var1);
    }
}

