/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml.schema;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.Extension;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.RepeatableSchemaConstruct;
import org.idoox.xml.schema.SchemaConstruct;

public class Type
extends RepeatableSchemaConstruct
implements Serializable,
Cloneable {
    private int hashCode = -1;
    public static final short KIND_UNKNOWN = 0;
    public static final short KIND_PRIMITIVE_MASK = 16;
    public static final short KIND_PRIMITIVE = 16;
    public static final short KIND_PRIMITIVE_LIST = 17;
    public static final short KIND_PRIMITIVE_UNION = 18;
    public static final short KIND_PRIMITIVE_COMPLEX = 19;
    public static final short KIND_PRIMITIVE_ENUMERATION = 20;
    public static final short KIND_COMPLEX_MASK = 32;
    public static final short KIND_STRUCTURE = 33;
    public static final short KIND_ARRAY = 34;
    public static final short KIND_SEQUENCE = 35;
    public static final short KIND_GROUP = 36;
    public static final short KIND_ALL = 37;
    public static final short KIND_CHOICE = 38;
    public static final short KIND_ANY = 39;
    private short kind;
    private Type baseType;
    private int dimensions;
    private SchemaConstruct[] subconstructs;
    private int subconstructsLength;
    private Attribute[] attributes;
    private AttributeGroup[] attributeGroups;
    private boolean mixed;
    private boolean inheritedByExtension;
    private Map parsedExtensions = new TreeMap();
    private String javaTypeName;
    protected static String[] SIMPLE_KIND_ARRAY_STRING = new String[]{"pri", "lst", "uni", "wattr", "enum"};
    protected static String[] COMPLEX_KIND_ARRAY_STRING = new String[]{"err", "str", "arr", "seq", "grp", "all", "choice", "any"};
    private static QName ABSTRACT_QNAME = new QName("abstract");

    public Type() {
        super(SchemaConstruct.ConstructType.TYPE);
    }

    public Type(QName name) {
        super(SchemaConstruct.ConstructType.TYPE, name);
    }

    public Type(QName name, short kind) {
        super(SchemaConstruct.ConstructType.TYPE, name);
        this.kind = kind;
    }

    public Type(QName name, short kind, Type baseType, int minOccurs, int maxOccurs) {
        super(SchemaConstruct.ConstructType.TYPE, name);
        this.kind = kind;
        this.baseType = baseType;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public void setBaseType(Type baseType) {
        this.baseType = baseType;
    }

    public short getKind() {
        return this.kind;
    }

    public void setKind(short kind) {
        this.kind = kind;
    }

    public void setName(QName name) {
        super.setName(name);
        this.hashCode = -1;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int dimensions) {
        this.dimensions = dimensions;
    }

    public SchemaConstruct[] getSubconstructs() {
        if (this.subconstructs == null) {
            return null;
        }
        if (this.subconstructsLength != this.subconstructs.length) {
            SchemaConstruct[] _m = new SchemaConstruct[this.subconstructsLength];
            System.arraycopy(this.subconstructs, 0, _m, 0, this.subconstructsLength);
            this.subconstructs = _m;
        }
        return this.subconstructs;
    }

    public void setSubconstructs(SchemaConstruct[] subconstructs) {
        this.subconstructsLength = subconstructs != null ? subconstructs.length : 0;
        this.subconstructs = subconstructs;
    }

    public void addSubconstruct(SchemaConstruct subconstruct) {
        if (this.subconstructs != null) {
            if (this.subconstructsLength >= this.subconstructs.length) {
                SchemaConstruct[] _m = new SchemaConstruct[this.subconstructs.length + 3];
                System.arraycopy(this.subconstructs, 0, _m, 0, this.subconstructs.length);
                this.subconstructs = _m;
            }
        } else {
            this.subconstructs = new SchemaConstruct[3];
        }
        this.subconstructs[this.subconstructsLength++] = subconstruct;
        subconstruct.setParent(this);
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(Attribute attribute) {
        if (this.attributes != null) {
            Attribute[] _m = new Attribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, _m, 0, this.attributes.length);
            this.attributes = _m;
        } else {
            this.attributes = new Attribute[1];
        }
        this.attributes[this.attributes.length - 1] = attribute;
        attribute.setParent(this);
    }

    public AttributeGroup[] getAttributeGroups() {
        return this.attributeGroups;
    }

    public void setAttributeGroups(AttributeGroup[] attributeGroups) {
        this.attributeGroups = attributeGroups;
    }

    public void addAttributeGroup(AttributeGroup attributeGroup) {
        if (this.attributeGroups != null) {
            AttributeGroup[] _m = new AttributeGroup[this.attributeGroups.length + 1];
            System.arraycopy(this.attributeGroups, 0, _m, 0, this.attributeGroups.length);
            this.attributeGroups = _m;
        } else {
            this.attributeGroups = new AttributeGroup[1];
        }
        this.attributeGroups[this.attributeGroups.length - 1] = attributeGroup;
        attributeGroup.setParent(this);
    }

    public boolean isMixed() {
        return this.mixed;
    }

    public void setMixed(boolean mixed) {
        this.mixed = mixed;
    }

    public boolean isInheritedByExtension() {
        return this.inheritedByExtension;
    }

    public void setInheritedByExtension(boolean inheritedByExtension) {
        this.inheritedByExtension = inheritedByExtension;
    }

    public boolean isInheritedByRestriction() {
        return !this.inheritedByExtension;
    }

    public void setInheritedByRestriction(boolean inheritedByRestriction) {
        this.inheritedByExtension = !inheritedByRestriction;
    }

    public Extension getExtension(String type) {
        return (Extension)this.parsedExtensions.get(type);
    }

    public void setExtension(String type, Extension extension) {
        this.parsedExtensions.put(type, extension);
    }

    public Iterator getExtensionTypes() {
        return this.parsedExtensions.keySet().iterator();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("Type[name=");
        if (this.name != null) {
            ret.append(this.name);
        } else {
            ret.append("<unknown>");
        }
        ret.append(" kind=");
        if (this.kind == 0) {
            ret.append("unk");
        } else if ((this.kind & 0x10) != 0) {
            ret.append(SIMPLE_KIND_ARRAY_STRING[this.kind & 0xFFFFFFEF]);
        } else if ((this.kind & 0x20) != 0) {
            ret.append(COMPLEX_KIND_ARRAY_STRING[this.kind & 0xFFFFFFDF]);
        }
        ret.append(" extensions=");
        ret.append(this.parsedExtensions);
        ret.append("]");
        return ret.toString();
    }

    public String toIndentedString(int level, Set alreadyProcessed) {
        int i;
        int i2;
        StringBuffer ret = new StringBuffer();
        int i3 = 0;
        while (i3 < level) {
            ret.append(' ');
            ++i3;
        }
        ret.append("Type [ ");
        ret.append(" name=");
        ret.append(this.name != null ? this.name.toString() : "<unknown>");
        if (alreadyProcessed.contains(this)) {
            ret.append(" ... ]");
            return ret.toString();
        }
        alreadyProcessed.add(this);
        ret.append(" kind=");
        if (this.kind == 0) {
            ret.append("unk");
        } else if ((this.kind & 0x10) != 0) {
            ret.append(SIMPLE_KIND_ARRAY_STRING[this.kind & 0xFFFFFFEF]);
        } else if ((this.kind & 0x20) != 0) {
            ret.append(COMPLEX_KIND_ARRAY_STRING[this.kind & 0xFFFFFFDF]);
        }
        ret.append(" occurs=");
        ret.append(this.minOccurs);
        ret.append(',');
        ret.append(this.maxOccurs);
        ret.append(" dims=");
        ret.append(this.dimensions);
        if (this.baseType != null) {
            ret.append(" base=\n");
            ret.append(this.baseType.toIndentedString(level + 4, alreadyProcessed));
        }
        if (this.javaTypeName != null) {
            ret.append(" javaType=");
            ret.append(this.javaTypeName);
            ret.append("\n");
        }
        if (this.subconstructs != null) {
            ret.append("\n");
            i2 = 0;
            while (i2 < level + 4) {
                ret.append(' ');
                ++i2;
            }
            ret.append("subconstructs=");
            i = 0;
            while (i < this.subconstructsLength) {
                ret.append("\n");
                ret.append(this.subconstructs[i].toIndentedString(level + 8, alreadyProcessed));
                ++i;
            }
        }
        if (this.reference != null) {
            ret.append(" ref=");
            ret.append(this.reference.getName());
        }
        if (this.attributes != null) {
            ret.append("\n");
            i2 = 0;
            while (i2 < level + 4) {
                ret.append(' ');
                ++i2;
            }
            ret.append("attributes=");
            i = 0;
            while (i < this.attributes.length) {
                ret.append("\n");
                ret.append(this.attributes[i].toIndentedString(level + 8, alreadyProcessed));
                ++i;
            }
        }
        if (this.parsedExtensions != null && this.parsedExtensions.size() > 0) {
            ret.append("\n");
            ret.append(" extensions=");
            ret.append(this.parsedExtensions);
        }
        ret.append("]");
        return ret.toString();
    }

    public Member[] getMembers() {
        LinkedList<SchemaConstruct> members = new LinkedList<SchemaConstruct>();
        Type type = this;
        while (true) {
            SchemaConstruct[] schemaConstruct = type.getSubconstructs();
            int i = schemaConstruct.length - 1;
            while (i >= 0) {
                SchemaConstruct sc = schemaConstruct[i];
                if (sc.getConstructType() == SchemaConstruct.ConstructType.MEMBER) {
                    members.add(0, sc);
                } else if (sc.getConstructType() == SchemaConstruct.ConstructType.TYPE) {
                    Member[] typeMembers = ((Type)sc).getMembers();
                    int j = typeMembers.length;
                    while (j >= 0) {
                        members.add(0, typeMembers[j]);
                        ++j;
                    }
                }
                --i;
            }
            Type baseType = type.getBaseType();
            if (baseType == null || baseType.getConstructType() != SchemaConstruct.ConstructType.TYPE) break;
            type = baseType;
        }
        return members.toArray(new Member[members.size()]);
    }

    public void setMembers(Member[] members) {
        this.setSubconstructs(members);
    }

    public void addMember(Member member) {
        this.addSubconstruct(member);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Type)) {
            return false;
        }
        if (this.name != null) {
            return this.name.equals(((Type)other).getName());
        }
        return this == other;
    }

    public int hashCode() {
        if (this.hashCode < 0) {
            this.hashCode = this.getName() != null ? this.getName().hashCode() : System.identityHashCode(this);
        }
        return this.hashCode;
    }

    public Object clone() {
        Type t = new Type();
        t.copyFrom(this);
        return t;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public void setJavaTypeName(String javaTypeName) {
        this.javaTypeName = javaTypeName;
    }

    public void copyFrom(SchemaConstruct anotherConstruct) {
        super.copyFrom(anotherConstruct);
        Type anotherType = (Type)anotherConstruct;
        this.setName(anotherType.getName());
        this.javaTypeName = anotherType.javaTypeName;
        this.kind = anotherType.kind;
        this.baseType = anotherType.baseType;
        this.dimensions = anotherType.dimensions;
        this.subconstructsLength = anotherType.subconstructsLength;
        this.mixed = anotherType.mixed;
        this.inheritedByExtension = anotherType.inheritedByExtension;
        this.parsedExtensions = anotherType.parsedExtensions != null ? new TreeMap(anotherType.parsedExtensions) : null;
        if (anotherType.subconstructs != null) {
            this.subconstructs = new SchemaConstruct[anotherType.subconstructs.length];
            System.arraycopy(anotherType.subconstructs, 0, this.subconstructs, 0, this.subconstructsLength);
        } else {
            this.subconstructs = null;
        }
        if (anotherType.attributes != null) {
            this.attributes = new Attribute[anotherType.attributes.length];
            System.arraycopy(anotherType.attributes, 0, this.attributes, 0, this.attributes.length);
        } else {
            this.attributes = null;
        }
        if (anotherType.attributeGroups != null) {
            this.attributeGroups = new AttributeGroup[anotherType.attributeGroups.length];
            System.arraycopy(anotherType.attributeGroups, 0, this.attributeGroups, 0, this.attributeGroups.length);
        } else {
            this.attributeGroups = null;
        }
    }

    public boolean containsInFirst(String localName) {
        if (localName == null && this.minOccurs == 0) {
            return true;
        }
        if (this.reference != null) {
            return this.reference.containsInFirst(localName);
        }
        switch (this.kind) {
            case 35: {
                return this.containsInSequence(localName);
            }
            case 38: {
                return this.containsInChoice(localName);
            }
            case 37: {
                return this.containsInAll(localName);
            }
            case 39: {
                return true;
            }
        }
        return false;
    }

    private boolean containsInSequence(String localName) {
        if (localName != null) {
            if (this.subconstructs == null) {
                return false;
            }
            int i = 0;
            while (i < this.subconstructs.length) {
                if (this.subconstructs[i].containsInFirst(localName)) {
                    return true;
                }
                if (!this.subconstructs[i].containsInFirst(null)) {
                    return false;
                }
                ++i;
            }
            return false;
        }
        if (this.subconstructs == null) {
            return true;
        }
        int i = 0;
        while (i < this.subconstructs.length) {
            if (!this.subconstructs[i].containsInFirst(null)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean containsInChoice(String localName) {
        int i = 0;
        while (i < this.subconstructs.length) {
            if (this.subconstructs[i].containsInFirst(localName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsInAll(String localName) {
        if (localName != null) {
            int i = 0;
            while (i < this.subconstructs.length) {
                if (this.subconstructs[i].containsInFirst(localName)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public boolean isAbstract() {
        Map facets = this.getFacets();
        if (facets == null) {
            return false;
        }
        return "true".equals(facets.get(ABSTRACT_QNAME));
    }
}

