/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.xml;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TokenizerWrapper
implements Tokenizer {
    private static final Token CONTENT_TOKEN = new Token();
    private Tokenizer tokenizer;
    private TokenizerState state;
    private DefaultTokenizerState defaultState;

    public TokenizerWrapper(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    protected TokenizerState getCurrentState() {
        return this.state;
    }

    protected void setCurrentState(TokenizerState state) {
        this.state = state;
    }

    private void setCurrentState(Token currentToken, String content, Map prefixMap, String[] newPrefixes) {
        if (this.defaultState == null) {
            this.defaultState = new DefaultTokenizerState();
        }
        this.defaultState.setToken(currentToken);
        this.defaultState.setContent(content);
        this.defaultState.setNamespaceDeclarations(prefixMap);
        this.defaultState.setNewPrefixes(newPrefixes);
        this.setCurrentState(this.defaultState);
    }

    protected void setCurrentToken(Token currentToken) {
        this.setCurrentState(currentToken, null, null, null);
    }

    protected void setCurrentContent(String content) {
        this.setCurrentState(CONTENT_TOKEN, content, null, null);
    }

    protected void setCurrentToken(Token currentToken, Map prefixMap, String[] newPrefixes) {
        this.setCurrentState(currentToken, null, prefixMap, newPrefixes);
    }

    protected Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    protected void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public String getLocalName() throws TokenizerException {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.getLocalName();
        }
        Token t = state.getToken();
        if (t.type == 2 || t.type == 3) {
            return t.localName;
        }
        throw new TokenizerException("Not available - not in token");
    }

    public String getNamespace() throws TokenizerException {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.getNamespace();
        }
        Token t = state.getToken();
        if (t.type == 2 || t.type == 3) {
            return t.uri;
        }
        throw new TokenizerException("Not available - not in token");
    }

    public String getNamespaceForPrefix(String prefix) {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.getNamespaceForPrefix(prefix);
        }
        Map namespaceDeclarations = state.getNewNamespaceDeclarations();
        if (namespaceDeclarations == null) {
            namespaceDeclarations = state.getNamespaceDeclarations();
        }
        if (namespaceDeclarations == null) {
            return this.tokenizer.getNamespaceForPrefix(prefix);
        }
        return (String)namespaceDeclarations.get(prefix);
    }

    public Element getDOMRepresentation(Document doc) throws TokenizerException {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.getDOMRepresentation(doc);
        }
        throw new UnsupportedOperationException("not supported");
    }

    /*
     * Unable to fully structure code
     */
    public static Element getDOMRepresentation(Tokenizer tokenizer, Document doc) throws TokenizerException {
        try {
            prefix2Ns = tokenizer.getCurrentPrefixMap();
            ret = null;
            depth = 0;
            nodeStack = new Stack<Node>();
            tok = tokenizer.currentState();
            token = new Token();
            prefixStack = new DeclaredPrefixesStack();
            block7: while (true) {
                switch (tok) {
                    case 2: {
                        tokenizer.readToken(token);
                        qName = token.prefix == null || token.prefix.length() == 0 ? token.getLocalName() : token.prefix + ":" + token.getLocalName();
                        el = doc.createElementNS(token.getNamespace(), qName);
                        if (depth == 0) {
                            ret = el;
                            i = prefix2Ns.entrySet().iterator();
                            while (i.hasNext()) {
                                e = i.next();
                                if (e.getValue() == null) continue;
                                prefix = (String)e.getKey();
                                ns = (String)e.getValue();
                                TokenizerWrapper.addPrefixDeclaration(prefix, el, ns);
                            }
                        } else {
                            prefixStack.used = 0;
                            tokenizer.pushNewlyDeclaredPrefixes(prefixStack);
                            i = 0;
                            while (i < prefixStack.used) {
                                prefix = prefixStack.prefixes[i];
                                ns = prefixStack.prefixValues[i];
                                TokenizerWrapper.addPrefixDeclaration(prefix, el, ns);
                                ++i;
                            }
                        }
                        i = 0;
                        while (i < token.getAttributeCount()) {
                            ap = token.getAttribute(i);
                            el.setAttributeNS(ap.uri, ap.qName, ap.value);
                            ++i;
                        }
                        nodeStack.push(el);
                        ++depth;
                        ** GOTO lbl60
                    }
                    case 3: {
                        el = (Element)nodeStack.pop();
                        if (--depth <= 0) break block7;
                        ((Element)nodeStack.peek()).appendChild(el);
                        ** GOTO lbl60
                    }
                    case 4: {
                        text = doc.createTextNode(tokenizer.readContent());
                        if (nodeStack.empty()) {
                            nodeStack.push(text);
                        } else {
                            ((Element)nodeStack.peek()).appendChild(text);
                        }
                    }
lbl60:
                    // 5 sources

                    default: {
                        tok = tokenizer.next();
                        if (depth > 0) continue block7;
                    }
                }
                break;
            }
            return ret;
        }
        catch (IOException e) {
            throw new TokenizerException(e);
        }
    }

    private static void addPrefixDeclaration(String prefix, Element el, String ns) {
        if (prefix == null || prefix.length() == 0) {
            el.setAttribute("xmlns", ns);
        } else if (!"xml".equals(prefix)) {
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, ns);
        }
    }

    public QName parseQName(String qName) {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.parseQName(qName);
        }
        if (qName.charAt(0) == '{') {
            return QName.valueOf(qName);
        }
        int p = qName.indexOf(58);
        String prefix = null;
        String localName = qName.substring(p + 1);
        if (p > 0) {
            prefix = qName.substring(0, p);
        }
        return new QName(this.getNamespaceForPrefix(prefix), localName);
    }

    public byte next() throws TokenizerException, IOException {
        this.setCurrentState(null);
        return this.tokenizer.next();
    }

    public static byte nextElement(Tokenizer tokenizer) throws IOException, TokenizerException {
        byte state;
        while ((state = tokenizer.next()) == 4) {
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte nextSibling(Tokenizer source) throws TokenizerException, IOException, IllegalStateException {
        byte tok;
        if (source.currentState() != 2) {
            throw new IllegalStateException("Tokenizer MUST be on START_TOKEN");
        }
        int depth = 0;
        block5: while (true) {
            tok = TokenizerWrapper.nextElement(source);
            switch (tok) {
                case 2: {
                    ++depth;
                    continue block5;
                }
                case 3: {
                    if (--depth < 0) return TokenizerWrapper.nextElement(source);
                    continue block5;
                }
                case 1: {
                    return 1;
                }
            }
            break;
        }
        throw new TokenizerException("Unexpected Token - " + TokenizerWrapper.tokenToString(tok));
    }

    public byte currentState() {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.currentState();
        }
        Token t = state.getToken();
        if (t == null) {
            throw new RuntimeException("Error: TokenizerWrapper " + this.getClass() + " returned state != null but state.getToken() == null! (wrapped tokenizer==" + this.tokenizer + "," + " wrapped tokenizer.currentState() ==" + this.tokenizer.currentState() + ")");
        }
        return t.type;
    }

    public String readContent() throws TokenizerException {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.readContent();
        }
        Token t = state.getToken();
        if (t.type != 4) {
            throw new TokenizerException("no content available to read");
        }
        return state.getContent();
    }

    public void readToken(Token stoken) throws TokenizerException, IOException {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            this.tokenizer.readToken(stoken);
            return;
        }
        Token t = state.getToken();
        if (t.type == 3) {
            stoken.uri = t.uri;
            stoken.localName = t.localName;
            stoken.type = (byte)3;
            return;
        }
        if (t.type == 2) {
            stoken.type = (byte)2;
            stoken.uri = t.uri;
            stoken.localName = t.localName;
            stoken.prefix = t.prefix;
            stoken.ensureCapacity(t.attEnd);
            stoken.attEnd = t.attEnd;
            int i = 0;
            while (i < t.attEnd) {
                Attribute ap = t.attArr[i];
                Attribute att = stoken.attArr[i];
                att.prefix = ap.prefix;
                att.qName = ap.qName;
                att.localName = ap.localName;
                att.value = ap.value;
                att.uri = ap.uri;
                ++i;
            }
            return;
        }
        throw new TokenizerException("no token to be read");
    }

    public boolean whitespaceContent() throws TokenizerException {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.whitespaceContent();
        }
        Token t = state.getToken();
        if (t.type != 4) {
            throw new TokenizerException("No content available");
        }
        return state.getContent().trim().length() == 0;
    }

    public Map getCurrentPrefixMap() {
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.getCurrentPrefixMap();
        }
        Map namespaceDeclarations = state.getNewNamespaceDeclarations();
        if (namespaceDeclarations == null) {
            return state.getNamespaceDeclarations();
        }
        namespaceDeclarations.putAll(this.tokenizer.getCurrentPrefixMap());
        return namespaceDeclarations;
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        byte token;
        TokenizerState state = this.getCurrentState();
        if (state == null) {
            return this.tokenizer.pushNewlyDeclaredPrefixes(prefixes);
        }
        Map namespaceDeclarations = state.getNewNamespaceDeclarations();
        if (namespaceDeclarations != null) {
            int newPrefixCount = namespaceDeclarations.size();
            prefixes.enlarge(newPrefixCount);
            int l = prefixes.used + newPrefixCount;
            Iterator it = namespaceDeclarations.entrySet().iterator();
            int i = prefixes.used;
            while (i < l) {
                Map.Entry entry = it.next();
                prefixes.prefixes[i] = (String)entry.getKey();
                prefixes.prefixValues[i] = (String)entry.getValue();
                prefixes.previousPrefixValues[i] = null;
                ++i;
            }
            prefixes.used += newPrefixCount;
            return newPrefixCount;
        }
        namespaceDeclarations = state.getNamespaceDeclarations();
        String[] newPrefixes = state.getNewPrefixes();
        if (namespaceDeclarations == null && newPrefixes == null && this.tokenizer != null && ((token = this.tokenizer.currentState()) == 2 || token == 3)) {
            return this.tokenizer.pushNewlyDeclaredPrefixes(prefixes);
        }
        if (newPrefixes == null) {
            return 0;
        }
        prefixes.enlarge(newPrefixes.length);
        int l = prefixes.used + newPrefixes.length;
        int i = prefixes.used;
        while (i < l) {
            String newPrefix;
            prefixes.prefixes[i] = newPrefix = newPrefixes[i];
            prefixes.prefixValues[i] = (String)namespaceDeclarations.get(newPrefix);
            prefixes.previousPrefixValues[i] = null;
            ++i;
        }
        prefixes.used += newPrefixes.length;
        return newPrefixes.length;
    }

    public static String tokenToString(byte token) {
        switch (token) {
            case 2: {
                return "START_TOKEN";
            }
            case 4: {
                return "CONTENT";
            }
            case 3: {
                return "END_TOKEN";
            }
            case 1: {
                return "END_DOCUMENT";
            }
            case 0: {
                return "UNKNOWN";
            }
        }
        return "Token=" + token;
    }

    public static class DefaultTokenizerState
    implements TokenizerState {
        private Token currentToken;
        private String content;
        private Map namespaceDeclarations;
        private Map newNamespaceDeclarations;
        private String[] newPrefixes;

        private DefaultTokenizerState(Token currentToken, String content, Map prefixMap, String[] namespaceDeclarations, Map newNamespaceDeclarations) {
            this.currentToken = currentToken;
            this.content = content;
            this.namespaceDeclarations = prefixMap;
            this.newNamespaceDeclarations = newNamespaceDeclarations;
            this.newPrefixes = namespaceDeclarations;
        }

        public DefaultTokenizerState() {
        }

        public DefaultTokenizerState(Token currentToken) {
            this(currentToken, null, null, null, null);
        }

        public DefaultTokenizerState(String content) {
            this(CONTENT_TOKEN, content, null, null, null);
        }

        public DefaultTokenizerState(Token currentToken, Map newNamespaceDeclarations) {
            this(currentToken, null, null, null, newNamespaceDeclarations);
        }

        public DefaultTokenizerState(Token currentToken, Map namespaceDeclarations, String[] newPrefixes) {
            this(currentToken, null, namespaceDeclarations, newPrefixes, null);
        }

        public Token getToken() {
            return this.currentToken;
        }

        public void setToken(Token currentToken) {
            this.currentToken = currentToken;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public Map getNamespaceDeclarations() {
            return this.namespaceDeclarations;
        }

        public Map getNewNamespaceDeclarations() {
            return this.newNamespaceDeclarations;
        }

        public void setNamespaceDeclarations(Map namespaceDeclarations) {
            this.namespaceDeclarations = namespaceDeclarations;
        }

        public String[] getNewPrefixes() {
            return this.newPrefixes;
        }

        public void setNewPrefixes(String[] newPrefixes) {
            this.newPrefixes = newPrefixes;
        }

        static {
            CONTENT_TOKEN.type = (byte)4;
        }
    }

    public static interface TokenizerState {
        public Token getToken();

        public String getContent();

        public Map getNamespaceDeclarations();

        public Map getNewNamespaceDeclarations();

        public String[] getNewPrefixes();
    }
}

